<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('admin.home')); ?>">صفحه اصلی</a></li>
                <li class="active">لیست مدیریت پیام ها</li>
            </ol>
        </div>
    </div>

    <div class="row">
        <modal v-if="modal.destroy" @close="modal.destroy=false">
            <h3 style="margin:0" slot="header">آیا مایل به حدف هستید</h3>
            <div slot="body" class="row">
                <div class="col-md-12">
                    <div class="col-md-4">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center">شناسه</div>
                    </div>
                    <div class="col-md-8">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center" v-text="model.id"></div>
                    </div>
                    <div class="clearfix mb10"></div>
                    <div class="col-md-4">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center">مشخصات</div>
                    </div>
                    <div class="col-md-8">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center" v-text="model.title"></div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <a @click.prevent.default="Destroy" href="#!" class="waves-effect waves-green btn quarter">تایید</a>
                <a @click.prevent.default="modal.destroy=false" href="#!" class="waves-effect waves-green btn quarter blue-grey darken-2 left">انصراف</a>
            </div>
        </modal>
    </div>
    <div class="row white z-depth-1">
        <span class="blue-grey darken-3 white-text title percent-80 z-depth-2">لیست مدیریت پیام ها</span>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ticketManage_store')): ?>
            <div class="col-md-4 col-md-offset-4 mt10 text-center">
                <a :href="currentUrl+'/create'" class="waves-effect full waves-light btn blue darken-1" ><i class="material-icons left">add</i>ایجاد</a>
            </div>
        <?php endif; ?>
        <div class="col-md-12 mt20">
            <div class="col-md-12">
                <div class="input-field">
                    <input id="query" name="query" type="text" class="validate" v-model="query">
                    <label for="query">جستجو در تمامی فیلد ها</label>
                </div>
            </div>
            <div class="col-md-12 pd0">
                <ul class="collapsible popout" data-collapsible="accordion">
                    <li class="ml0 mr0">
                        <div class="collapsible-header"><i class="material-icons">search</i>جستجو پیشرفته</div>
                        <div class="collapsible-body row">
                            <div class="col-md-12">
                                <div class="input-field">
                                    <input id="title_label" name="title" type="text" class="validate" v-model="search.like_title">
                                    <label for="title_label">تیتر تیکت</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="input-field">
                                    <input id="userName_label" name="userName" type="text" class="validate" v-model="search.like_userName">
                                    <label for="userName_label">نام کاربری</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="input-field">
                                    <input id="email_label" name="email" type="text" class="validate" v-model="search.like_email">
                                    <label for="email_label">ایمیل</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="input-field">
                                    <input id="nationalCode" name="nationalCode" type="text" class="validate dleft" v-model="search.like_nationalCode">
                                    <label for="nationalCode">کد ملی</label>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="input-field">
                                    <input id="firstName" name="firstName" type="text" class="validate" v-model="search.like_firstName">
                                    <label for="firstName">نام</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="input-field">
                                    <input id="lastName" name="lastName" type="text" class="validate" v-model="search.like_lastName">
                                    <label for="lastName">نام خانوادگی</label>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="input-field">
                                    <input id="mobile" name="mobile" type="text" class="validate" v-model="search.like_mobile">
                                    <label for="mobile">موبایل</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="input-field">
                                    <input id="telephone" name="telephone" type="text" class="validate" v-model="search.like_telephone">
                                    <label for="telephone">تلفن</label>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-4 mb20">
                                <label for="gender">جنسیت</label>
                                <multiselect id="gender" v-model="gender.selected" :options="gender.list" label="title" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false"></multiselect>
                            </div>
                            <div class="col-md-4 mb20">
                                <label for="ageGroup">گروه سنی</label>
                                <multiselect id="ageGroup" v-model="ageGroup.selected" :options="ageGroup.list" label="title" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false"></multiselect>
                            </div>
                            <div class="col-md-4 mb20">
                                <label for="payStatus">وضعیت پرداخت</label>
                                <multiselect id="payStatus" v-model="payStatus.selected" :options="payStatus.list" label="title" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false"></multiselect>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="input-field">
                                    <i class="material-icons prefix">date_range</i>
                                    <input id="date_start" name="date_start" type="text" class="validate date">
                                    <label class="active" for="date_start">از تاریخ</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="input-field">
                                    <i class="material-icons prefix">date_range</i>
                                    <input id="date_end" name="date_end" type="text" class="validate date">
                                    <label class="active" for="date_end">تا تاریخ</label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button @click="Msearch" class="waves-effect waves-light btn quarter center-block blue-grey darken-2 mt20">جستجو</button>
                            </div>
                            <div class="col-md-6 text-right">
                                <button @click="getExcel" class="waves-effect waves-light btn quarter blue-grey darken-2 mt20">اکسل</button>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>

        <div class="col-md-12 pd4">
            <div class="table-responsive">
                <table class="table table-bordered table-hover white">
                    <thead class="blue-grey darken-2 white-text">
                    <tr>
                        <th @click="sort('id')">شناسه
                            <i v-if="params.id === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.id === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('title')">تیتر
                            <i v-if="params.title === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.title === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('user_id')">شناسه کاربر
                            <i v-if="params.user_id === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.user_id === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('user_id')">نام
                            <i v-if="params.user_id === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.user_id === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('user_id')">نام خانوادگی
                            <i v-if="params.user_id === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.user_id === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('ticketManage_id')">دپارتمان
                            <i v-if="params.ticketManage_id === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.ticketManage_id === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('referer_count')">تعداد ارجاع
                            <i v-if="params.referer_count === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.referer_count === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('status')">وضعیت
                            <i v-if="params.status === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.status === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('created_at')">تاریخ ایجاد
                            <i v-if="params.created_at === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.created_at === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th>عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr v-for="item in itemList">
                        <td v-text="item.id"></td>
                        <td v-text="item.title"></td>
                        <td v-text="item.user_id"></td>
                        <td v-text="item.user.firstName"></td>
                        <td v-text="item.user.lastName"></td>
                        <td v-text="item.department.title"></td>
                        <td v-text="item.referer_count"></td>
                        <td v-text="translateStatus(item.status)"></td>
                        <td v-text="item.created_at"></td>
                        <td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ticketManage_update')): ?>
                                <a :href="currentUrl+'/'+item.id+'/edit'" class="btn-floating waves-effect waves-light blue"><i class="material-icons">edit</i></a>
                            <?php endif; ?>
                                <a :href="'/panel/admin/ticket/ticketmessages/messages/'+item.id" class="btn-floating waves-effect waves-light blue mr20"><i class="material-icons">remove_red_eye</i></a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ticketManage_destroy')): ?>
                                <a href="#!" @click.prevent.default="callDestroy(item)" class="btn-floating waves-effect waves-light red mr20"><i class="material-icons">delete</i></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="col-md-12">
            <paginate v-if="itemList" v-model="itemList" :is-reset="reset" :url="currentUrl" :params="params"></paginate>
        </div>
    </div>
    <vue-toastr ref="toastr"></vue-toastr>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/modal.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/paginator.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vuetoaster.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/vueselect/vueselect.js')); ?>"></script>

<script>
    Vue.component('Multiselect', VueMultiselect.default);

    var vm = new Vue({
        el: '#app',
        data: {
            currentUrl: location.pathname,
            instance: axios.create({baseURL: location.pathname,}),
            ax:axios.create({baseURL: '/api',headers:{'Authorization':'Bearer <?php echo e(auth()->user()->api_token); ?>'}}),
            itemList: [],
            reset: false,
            params: {},
            query: '',
            search: {
                like_caseId: '',
                like_nationalCode: '',
                like_firstName: '',
                like_lastName: '',
                like_mobile: '',
                like_date_start: '',
                like_date_end: '',
                like_title: '',
            },
            modal: {
                destroy: false
            },
            model: {
                mode: 'create',
                id: '',
                title: '',
                body: '',
                destroy: []
            },
            gender: {
                list: [
                    {
                        id: 'male',
                        title: 'مرد'
                    },
                    {
                        id: 'female',
                        title: 'زن'
                    },
                ],
                selected: ''
            },
            ageGroup: {
                list: [
                    {
                        id: 'upEighteen',
                        title: 'بالای هجده سال'
                    },
                    {
                        id: 'downEighteen',
                        title: 'زیر هیجده سال'
                    },
                    {
                        id: 'all',
                        title: 'همه'
                    },
                ],
                selected: ''
            },
            payStatus: {
                list: [
                    {
                        id: 'success',
                        title: 'پرداخت شده'
                    },
                    {
                        id: 'error',
                        title: 'پرداخت نشده'
                    },
                ],
                selected: ''
            },
        },
        methods: {
            Msearch:function () {
                listParams = ['like_caseId','like_email', 'like_nationalCode', 'like_firstName', 'like_lastName', 'like_mobile', 'like_date_start', 'like_date_end'];
                for (var i = 0; i < listParams.length; i++) {
                    if (this.search[listParams[i]] === '' || this.search[listParams[i]] == undefined) {
                        delete this.search[listParams[i]];
                    }
                }

                if (this.gender.selected) {
                    this.search['gender'] = this.gender.selected.id;
                } else {
                    delete this.search['gender'];
                }

                if (this.ageGroup.selected) {
                    this.search['agegroup'] = this.ageGroup.selected.id;
                } else {
                    delete this.search['agegroup'];
                }

                if (this.payStatus.selected) {
                    this.search['paystatus'] = this.payStatus.selected.id;
                } else {
                    delete this.search['paystatus'];
                }

                this.params = this.search;
                this.reset  = !this.reset;
            },

            getExcel:function () {
                var url = '/panel/admin/ticket/tickets/excel?';
                listParams = ['like_email','like_title','like_userName', 'like_nationalCode', 'like_firstName', 'like_lastName', 'like_mobile', 'like_date_start', 'like_date_end'];
                for (var i = 0; i < listParams.length; i++) {
                    if (this.search[listParams[i]] !== "" && this.search[listParams[i]] != undefined) {
                        url += listParams[i] + '=' + this.search[listParams[i]] +'&';
                    }
                }


                if (this.gender.selected) {
                    url += 'gender=' + this.gender.selected.id+'&';
                }

                if (this.ageGroup.selected) {
                    url += 'ageGroup=' + this.ageGroup.selected.id+'&';
                }

                if (this.payStatus.selected) {
                    url += 'paystatus=' + this.payStatus.selected.id+'&';
                }

                window.location.href = url;
            },
            labelAge: function (age) {
                if (age > 18) {
                    return '+18';
                } else if (age == 0) {
                    return 'ثبت نشده'
                } else {
                    return '-18';
                }
            },
            toPersian: function (input) {
                return moment(input, 'YYYY/MM/DD HH:mm:ss').format('jYYYY/jMM/jDD');
            },

            translateStatus: function (status) {
                if (status == 'open') {
                    return 'باز';
                } else if(status == 'close') {
                    return 'بسته';
                } else if(status == 'pending') {
                    return 'در حال بررسی';
                } else {
                    return 'غیر فعال';
                }
            },
            sort: function (query) {
                this.reset = !this.reset;
                if (this.changeSort(this.params[query]) === '') {
                    delete this.params[query];
                } else {
                    this.params[query] = this.changeSort(this.params[query]);
                }
            },
            changeSort: function (value) {
                if (value === '' || value === undefined) {
                    return 'asc';
                } else if (value === 'asc') {
                    return 'desc'
                } else {
                    return ''
                }
            },
            callDestroy: function (item) {
                this.model = item;
                this.modal.destroy = true;
            },
            Destroy: function () {
                var id = this.model.id;
                this.instance.delete('/' + id, {}).then(function (response) {
                    this.reset = !this.reset;
                    this.modal.destroy = false;
                    this.$refs.toastr.defaultPosition = "toast-bottom-left";
                    this.$refs.toastr.s("<?php echo e(trans('Basic::all.delete.deleted')); ?>");
                }.bind(this));
            },
        },
        computed: {
            isEdit: function () {
                return (this.model.mode === 'edit');
            },
            isDestroy: function () {
                return (this.model.mode === 'destroy');
            },
        },
        watch: {
            query: function () {
                this.params.query = this.query;
                this.reset = !this.reset;
            },
        },
        components: {
            'vue-toastr': window.vueToastr,
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datePicker/persianDatePicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datePicker/custom.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/vueselect/vueselect.css')); ?>">

<style>
    .fixed-action-btn {
        right: 25px;
    }
    .fixed-action-btn ul a{
        width: 140px;
        -webkit-border-radius: 4px;
        -moz-border-radius: 4px;
        border-radius: 4px;
        text-align: right;
    }
    .fixed-action-btn ul a i {
        display: inline;
        position: absolute;
        top: 0;
        left: 55px;
    }
    .fixed-action-btn ul a span {
        position: absolute;
        right: 28px;
        bottom: 2px;
    }
    .fixed {
        position: fixed;
        right: 25px;
        bottom: 23px;
        z-index: 998;
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/work/emi/resources/views/admin/Ticket/manageTicket/index.blade.php ENDPATH**/ ?>