<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('admin.home')); ?>">صفحه اصلی</a></li>
                <li><a href="<?php echo e(route('admin.service.cardstatus.index')); ?>">لیست وضعیت کارت ها</a></li>
                <li class="active">ایجاد وضعیت کارت</li>
            </ol>
        </div>
    </div>

    <form method="post" action="<?php echo e(route('admin.service.cardstatus.store')); ?>">
        <?php echo e(csrf_field()); ?>

        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد وضعیت کارت</span>
                <?php echo $__env->make('share.extra.back2',['route'=>route('admin.service.cardstatus.index')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-12 mb20">
                <label for="cards">انتخاب کارت</label>
                <multiselect id="cards" v-model="serviceCard.selected" :options="serviceCard.list" @search-change="search($event,'serviceCard')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                    <span v-if="serviceCard.list.length > 0 && isMoreResult('serviceCard')"  @click="moreResult('serviceCard')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                        <span v-if="serviceCard.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                        <span v-else>موارد بیشتر</span>
                    </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'skill_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'title','title'=>'تیتر'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mt35">
                <?php echo $__env->make('share.forms.switch',['name'=>'status','title'=>'وضعیت','checked'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div>
                <input type="hidden" id="card_id" name="card_id">
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>

        </div>
    </form>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/vueselect/vueselect.js')); ?>"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer <?php echo e(auth()->user()->api_token); ?>'}}),

                serviceCard:{
                    url:'/admin/v1/service/card',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                this.search(null, 'serviceCard');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'serviceCard.selected': function () {
                    if (this.serviceCard.selected) {
                        document.getElementById('card_id').value = this.serviceCard.selected.id;
                    } else {
                        document.getElementById('card_id').value = null;
                    }
                },
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/vueselect/vueselect.css')); ?>">
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/work/emi/resources/views/admin/Service/cardStatus/create.blade.php ENDPATH**/ ?>