<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('admin.home')); ?>">صفحه اصلی</a></li>
                <li><a href="<?php echo e(route('admin.users.index')); ?>">لیست کاربران</a></li>
                <li class="active">ویرایش کاربر</li>
            </ol>
        </div>
    </div>

    <form method="post" action="<?php echo e(route('admin.users.update',$user->id)); ?>" enctype="multipart/form-data">
        <input type="hidden" name="_method" value="PUT">
        <?php echo e(csrf_field()); ?>

        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش کاربر</span>
                <?php echo $__env->make('share.extra.back2',['route'=>route('admin.users.index')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>


            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'userName','class'=>'dleft','title'=>'نام کاربری','value'=>$user->userName], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'email','class'=>'dleft','title'=>'ایمیل','value'=>$user->email], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'firstName','title'=>'نام','value'=>$user->firstName], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'lastName','title'=>'نام خانوادگی','value'=>$user->lastName], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'fatherName','title'=>'نام پدر','value'=>$user->fatherName], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.select',['name'=>'gender','title'=>'جنسیت','options'=>['male'=>'مرد','female'=>'زن'],'selected'=>$user->gender], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6 mb20">
                <label for="states">انتخاب استان محل سکونت</label>
                <multiselect id="states" v-model="state.selected" :options="state.list" @search-change="search($event,'state',{withstate:1})" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                    <span v-if="state.list.length > 0 && isMoreResult('state')"  @click="moreResult('state')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                        <span v-if="state.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                        <span v-else>موارد بیشتر</span>
                    </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'city_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mb20">
                <label for="cities">انتخاب شهر محل سکونت</label>
                <multiselect id="cities" v-model="city.selected" :options="city.list" @search-change="search($event,'city',{withstate:1})" :custom-label="cityLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                    <span v-if="city.list.length > 0 && isMoreResult('city')"  @click="moreResult('city')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                        <span v-if="city.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                        <span v-else>موارد بیشتر</span>
                    </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'city_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6 ">
                    <?php echo $__env->make('share.forms.input',['name'=>'nationalCode','class'=>'dleft','title'=>'کد ملی',
                  'extraFields'=>'v-model="nationalCode" :class="{invalid:!validnationalCode}"','value'=>$user->nationalCode], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <span v-if="!validnationalCode" class="error-block">کد ملی صحیح نیست</span>
                <?php echo $__env->make('share.forms.error',['name'=>'nationalCode'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'certificateCode','title'=>'شماره شناسنامه','value'=>$user->certificateCode], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6">
                <?php echo $__env->make('share.forms.date',['name'=>'birthday','title'=>'تاریخ تولد','value'=>$user->birthday,'disabled'=>false], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mt20">
                <?php echo $__env->make('share.forms.input',['name'=>'birthplace','title'=>'محل تولد','value'=>$user->birthplace], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'mobile','class'=>'dleft','title'=>'موبایل','value'=>$user->mobile], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'telephone','class'=>'dleft','title'=>'تلفن','value'=>$user->telephone], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-12">
                <?php echo $__env->make('share.forms.input',['name'=>'address','title'=>'آدرس','value'=>$user->address], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md mb20"></div>

            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'postalCode','class'=>'dleft','title'=>'کد پستی','value'=>$user->postalCode], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.select',['name'=>'type','title'=>'نوع کاربر','options'=>['admin'=>'مدیر','user'=>'کاربر'],'selected'=>$user->type], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix mb20"></div>

            <div class="col-md-12 mb20">
                <label for="skills">انتخاب مهارت</label>
                <multiselect id="skills" v-model="skill.selected" :options="skill.list" @search-change="search($event,'skill')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                <span v-if="skill.list.length > 0 && isMoreResult('skill')"  @click="moreResult('skill')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                                    <span v-if="skill.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                    <span v-else>موارد بیشتر</span>
                                </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'skill_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-3 mt20">
                <?php echo $__env->make('share.forms.switch',['name'=>'canEdit','title'=>'قابل ویرایش','checked'=>$user->canEdit], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-3 mt20">
                <?php echo $__env->make('share.forms.switch',['name'=>'saveSkill','title'=>'ثبت مهارت در سامانه','checked'=>$user->saveSkill], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-3">
                <?php echo $__env->make('share.forms.select',['name'=>'education','title'=>'آخرین مدرک تحصیلی','options'=>['1'=>'زیر دیپلم','2'=>'دیپلم','3'=>'کاردانی','4'=>'کارشناسی','5'=>'کارشناسی ارشد','6'=>'دکتری'],'selected'=>$user->education,'extraFields'=>'autocomplete="off"'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-3">
                <?php echo $__env->make('share.forms.input',['name'=>'fieldOfStudy','title'=>'آخرین رشته و گرایش','extraFields'=>'autocomplete="off"','value'=>$user->fieldOfStudy], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix mb20"></div>


            <div class="col-md-12">
                <?php echo $__env->make('share.forms.input',['name'=>'password','class'=>'dleft','title'=>'پسورد'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-12 mb20">
                <br><br>
                <hr>
                <label for="roles">سطح دسترسی</label>
                <multiselect id="roles" v-model="role.selected" :options="role.list" @search-change="search($event,'role')" :multiple="true" :close-on-select="false" :custom-label="roleLabel" track-by="id" :internal-search="false">
                        <span v-if="role.list.length > 0 && isMoreResult('role')"  @click="moreResult('role')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="role.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>More Result</span>
                        </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'roles_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="clearfix mb20"></div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.file',['title'=>'عکس آخرین مدرک تحصیلی','name'=>'educationPicture'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if($user->educationPicture): ?>
                    <a download="<?php echo e($user->educationPicture); ?>" href="<?php echo e(asset($user->educationPicture)); ?>">
                        <img class="img-raised center-block" height="100px" src="<?php echo e(asset($user->educationPicture)); ?>" alt="">
                    </a>
                <?php endif; ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.file',['title'=>'عکس پرسنلی','name'=>'personalPicture'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if($user->personalPicture): ?>
                    <a download="<?php echo e($user->personalPicture); ?>" href="<?php echo e(asset($user->personalPicture)); ?>">
                        <img class="img-raised center-block" height="100px" src="<?php echo e(asset($user->personalPicture)); ?>" alt="">
                    </a>
                <?php endif; ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.file',['title'=>'کارت ملی','name'=>'nationalCardPicture'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if($user->nationalCardPicture): ?>
                    <a download="<?php echo e($user->nationalCardPicture); ?>" href="<?php echo e(asset($user->nationalCardPicture)); ?>">
                        <img class="img-raised center-block" height="100px" src="<?php echo e(asset($user->nationalCardPicture)); ?>" alt="">
                    </a>
                <?php endif; ?>
            </div>
            <div class="clearfix mb20"></div>

            <div class="clearfix mt20"></div>
            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-2">ذخیره</button>
            </div>
            <div>
                <input type="hidden" id="roles_id" name="roles_id" value="<?php echo e($user->role->pluck('id')); ?>" >
                <input type="hidden" id="city_id" name="city_id" value="<?php echo e($user->city_id); ?>">
                <input type="hidden" id="skill_id" name="skill_id" value="<?php echo e((isset($skill->id)?$skill->id:'')); ?>">
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/vueselect/vueselect.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datePicker/persianDate.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datePicker/datePicker.js')); ?>"></script>

    <script>
        $(document).ready(function () {
            $("#birthday").pDatepicker({
                format : "YYYY/MM/DD",
                maxDate: new persianDate().valueOf(),
                initialValueType: 'gregorian'
            });

            $("#birthday").val('<?php echo e(toPersian($user->birthday)); ?>')
            $('select').material_select();
        });
    </script>


    <script>
        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el: '#app',
            data: {
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer <?php echo e(auth()->user()->api_token); ?>'}}),

                role:{
                    url:'/v1/admin/acl/role',
                    list:<?php echo $user->role; ?>,
                    selected:<?php echo $user->role; ?>,
                    query:'',
                    data:[],
                    loading:false
                },

                city:{
                    url:'/v1/region/city',
                    list:<?php echo ($user->city) ? '['.$user->city.']' :'[]'; ?>,
                    selected:<?php echo ($user->city) ? '['.$user->city.']' :'[]'; ?>,
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                state:{
                    url:'/v1/region/state',
                    list:<?php echo ($user->city) ? '['.$user->city->state.']' :'[]'; ?>,
                    selected:<?php echo ($user->city) ? '['.$user->city->state.']' :'[]'; ?>,
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                skill:{
                    url:'front/v1/skill/skill',
                    list:[<?php echo isset($skill->id)?$skill:''; ?>],
                    selected:[<?php echo isset($skill->id)?$skill:''; ?>],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                nationalCode:'<?php echo e($user->nationalCode); ?>',
                validnationalCode:true
            },
            created: function () {
                if (this.city.selected.length == 0) {
                    this.search(null, 'city',{withstate: 1});
                }

                if (this.city.selected.length == 0) {
                    this.search(null, 'state');
                }

                if (this.skill.selected.length == 0) {
                    this.search(null, 'skill');
                }

                if (this.role.selected.length == 0) {
                    this.search(null, 'role');
                }
            },
            methods: {
                checkNationalCode: function (code) {
                    var L = code.length;

                    if (L < 8 || parseInt(code, 10) == 0) return false;
                    code = ('0000' + code).substr(L + 4 - 10);
                    if (parseInt(code.substr(3, 6), 10) == 0) return false;
                    var c = parseInt(code.substr(9, 1), 10);
                    var s = 0;
                    for (var i = 0; i < 9; i++)
                        s += parseInt(code.substr(i, 1), 10) * (10 - i);
                    s = s % 11;
                    return (s < 2 && c == s) || (s >= 2 && c == (11 - s));
                    return true;
                },


                cityLabel: function (element) {
                    if (element.state) {
                        return element.state.title+'/'+element.title;
                    }
                    return element.title;
                },
                roleLabel: function (element) {
                    return element.name;
                },
                search: function (query,field,extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.title;
                },
                isMoreResult:function (field) {
                    return (this[field].data.current_page+1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                },
            },
            watch: {
                'role.selected': function () {
                    var output = [];
                    for (var i=0; i < this.role.selected.length ; i++){
                        output.push(this.role.selected[i]['id']);
                    }
                    document.getElementById('roles_id').value = JSON.stringify(output);
                },
                nationalCode: function () {
                    if (this.nationalCode === '') {
                        this.validnationalCode = true;
                    } else {
                        this.validnationalCode = this.checkNationalCode(this.nationalCode);
                    }
                },
                'state.selected': function () {
                    if (this.state.selected) {
                        this.search(null, 'city', {withstate: 1,state_id:this.state.selected.id});
                    } else {
                        this.city.list = [];
                        this.city.selected = [];
                        document.getElementById('city_id').value = null;
                    }
                },
                'city.selected': function () {
                    if (this.city.selected) {
                        document.getElementById('city_id').value = this.city.selected.id;
                    } else {
                        document.getElementById('city_id').value = null;
                    }
                },
                'skill.selected': function () {
                    if (this.skill.selected) {
                        document.getElementById('skill_id').value = this.skill.selected.id;
                    } else {
                        document.getElementById('skill_id').value = null;
                    }
                },
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/vueselect/vueselect.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datePicker/persianDatePicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datePicker/custom.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/emiteam/emi/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>