<?php $__env->startSection('content'); ?>
    <div class="container auth" id="vue_app">
        <div class="rw"></div>
        <div class="row mb40">
            <br><br><br><br>
            <div class="col-md-8 auth-login col-md-offset-2">
                <form class="form-horizontal" role="form" method="POST" action="<?php echo e(route('front.inquiry.cervicecard.store')); ?>">
                    <?php echo e(csrf_field()); ?>

                    <div class="card">
                        <span class="card-title center-block text-center pd10 white-text col-md-10 col-md-offset-1 auth-title">استعلام <?php echo e($type); ?></span>
                        <div class="card-content row">

                            <br>
                            <div class="col-md-12 mt25">
                                <?php echo $__env->make('share.forms.input',['name'=>'mobile','title'=>'شماره موبایل','class'=>'dleft','extraFields'=>'autocomplete=off'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-md-12 mt25">
                                <?php echo $__env->make('share.forms.input',['name'=>'nationalCode','title'=>'کد ملی','class'=>'dleft','extraFields'=>'autocomplete=off'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>

                            <div class="col-md-12 text-center mt40">
                                <div class="col-md-12">
                                    <label for="states_vue">انتخاب استان محل سکونت</label>
                                    <multiselect id="states_vue" v-model="state.selected" :options="state.list" @search-change="search($event,'state')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                        <span v-if="state.list.length > 0 && isMoreResult('state')"  @click="moreResult('state')" class="waves-effect waves-light btn half center-block teal darken-2 mt20" slot="afterList">
                                            <span v-if="state.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                            <span v-else>موارد بیشتر</span>
                                        </span>
                                    </multiselect>
                                </div>
                                <div class="col-md-12 mt20">
                                    <label for="cities_vue">انتخاب شهر محل سکونت</label>
                                    <multiselect id="cities_vue" v-model="city.selected" :options="city.list" @search-change="search($event,'city',{withstate:1,state:state.selected.id})" :custom-label="cityLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                <span v-if="city.list.length > 0 && isMoreResult('city')"  @click="moreResult('city')" class="waves-effect waves-light btn half center-block teal darken-2 mt20" slot="afterList">
                                    <span v-if="city.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                    <span v-else>موارد بیشتر</span>
                                </span>
                                    </multiselect>
                                    <?php echo $__env->make('share.forms.error',['name'=>'city_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-md-12 mt20">
                                    <label for="skills">انتخاب مهارت / تخصص</label>
                                    <multiselect id="skills" v-model="skill.selected" :options="skill.list" @search-change="search($event,'skill')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                    <span v-if="skill.list.length > 0 && isMoreResult('skill')"  @click="moreResult('skill')" class="waves-effect waves-light btn half center-block teal darken-2 mt20" slot="afterList">
                                        <span v-if="skill.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                        <span v-else>موارد بیشتر</span>
                                    </span>
                                    </multiselect>
                                    <?php echo $__env->make('share.forms.error',['name'=>'skill_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>


                        <?php if(isset($serviceCardStatusUser) && isset($serviceCardStatus)): ?>
                                <div class="col-md-12">
                                    <div class="userstatus">
                                        <div class="col-md-12"></div>
                                        <div class="col-md-3 text-center">
                                            <div class="col-md-12">
                                                <i class="fa fa-check-circle-o circle-checked" aria-hidden="true"></i>
                                            </div>
                                            <p class="col-md-12 text-center">
                                                در انتظار
                                            </p>
                                        </div>
                                        <?php $__currentLoopData = $serviceCardStatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-3 text-center">
                                                <div class="col-md-12 text-center">
                                                    <?php if($serviceCardStatusUser->where('id',$status->id)->first()): ?>
                                                        <i class="fa fa-check-circle-o circle-checked" aria-hidden="true"></i>
                                                    <?php else: ?>
                                                        <p class="circle center-block text-center"></p>
                                                    <?php endif; ?>
                                                </div>
                                                <p class="col-md-12 text-center"><?php echo e($status->title); ?></p>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                        <?php endif; ?>

                        </div>
                        <div class="card-action">
                            <button class="waves-effect waves-light btn center-block half blue darken-2" type="submit">
                                ذخیره و نمایش
                            </button>
                        </div>

                    </div>
                </form>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

    <script>

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el: '#vue_app',
            data: {
                ax:axios.create({baseURL: baseUrl}),
                state:{
                    url:'/v1/region/state',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                city:{
                    url:'/v1/region/city',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
                skill:{
                    url:'front/v1/skill/skill',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

            },
            created:function () {
                this.search(null, 'state', {});
                this.search(null, 'skill', {orderby_id: "asc"});
            },
            methods: {
                cityLabel: function (element) {
                    return element.title;
                },
                searchBtn: function () {
                    if (this.city.selected.id && this.skill.selected.id) {
                        window.location.href = "skill?city_id="+this.city.selected.id +'&skill_id='+this.skill.selected.id;

                    } else {
                        if (!this.city.selected.id) {
                            swal({
                                title: 'لطفا شهر را انتخاب کنید',
                                text: 'لطفا شهر را انتخاب کنید',
                                type: "warning",
                                showConfirmButton: true,
                            });
                        } else if(!this.skill.selected.id){
                            swal({
                                title: 'لطفا مهارت را انتخاب کنید',
                                text: 'لطفا مهارت را انتخاب کنید',
                                type: "warning",
                                showConfirmButton: true,
                            });
                        }

                    }
                },

                search: function (query,field,extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id+' - '+element.title;
                },
                isMoreResult:function (field) {
                    return (this[field].data.current_page+1 <= this[field].data.last_page);
                },
                moreResult:function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch: {
                'state.selected': function () {
                    if (this.state.selected) {
                        this.search(null, 'city', {withstate: 1,state_id:this.state.selected.id});
                    } else {
                        this.city.list = [];
                        this.city.selected = [];
                    }
                },
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('front.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/work/emi/resources/views/front/inqueryServiceCard/show.blade.php ENDPATH**/ ?>