<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('user.home')); ?>">صفحه اصلی</a></li>
                <li class="active">ویرایش پروفایل</li>
            </ol>
        </div>
    </div>

    <form method="post" action="<?php echo e(route('user.profile.update')); ?>" enctype="multipart/form-data">
        <input type="hidden" name="_method" value="PUT">
        <?php echo e(csrf_field()); ?>

        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش پروفایل</span>
            </div>


            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'email','class'=>'dleft','title'=>'ایمیل','value'=>auth()->user()->email,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'firstName','title'=>'نام','value'=>auth()->user()->firstName,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'lastName','title'=>'نام خانوادگی','value'=>auth()->user()->lastName,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6">
                <?php echo $__env->make('share.forms.select',['name'=>'gender','title'=>'جنسیت','options'=>['male'=>'مرد','female'=>'زن'],'selected'=>auth()->user()->gender,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'fatherName','id'=>'fatherName','title'=>'نام پدر','value'=>auth()->user()->fatherName,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>


            <div class="col-md-6 mb20">
                <label for="statess">انتخاب استان محل سکونت</label>
                <multiselect <?php echo e($disabled); ?> id="statess" v-model="state.selected" :options="state.list" @search-change="search($event,'state',{withstate:1})" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                    <span v-if="state.list.length > 0 && isMoreResult('state')"  @click="moreResult('state')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                        <span v-if="state.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                        <span v-else>موارد بیشتر</span>
                    </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'city_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mb20">
                <label for="citiess">انتخاب شهر محل سکونت</label>
                <multiselect <?php echo e($disabled); ?> id="citiess" v-model="city.selected" :options="city.list" @search-change="search($event,'city',{withstate:1})" :custom-label="cityLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                    <span v-if="city.list.length > 0 && isMoreResult('city')"  @click="moreResult('city')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                        <span v-if="city.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                        <span v-else>موارد بیشتر</span>
                    </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'city_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>


            <div class="col-md-12 mb20">
                <label for="skills">انتخاب مهارت</label>
                <multiselect <?php echo e($disabled); ?> id="skills" v-model="skill.selected" :options="skill.list" @search-change="search($event,'skill')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                    <span v-if="skill.list.length > 0 && isMoreResult('skill')"  @click="moreResult('skill')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                        <span v-if="skill.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                        <span v-else>موارد بیشتر</span>
                    </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'skill_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>
            <div class="col-md-6">
                    <?php echo $__env->make('share.forms.input',['name'=>'nationalCode','class'=>'dleft','title'=>'کد ملی',
                  'extraFields'=>'v-model="nationalCode" :class="{invalid:!validnationalCode}"','value'=>auth()->user()->nationalCode,'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <span v-if="!validnationalCode" class="error-block">کد ملی صحیح نیست</span>
                <?php echo $__env->make('share.forms.error',['name'=>'nationalCode'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'certificateCode','title'=>'شماره شناسنامه','value'=>auth()->user()->certificateCode,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>

            <div class="col-md-6">
                <?php echo $__env->make('share.forms.date',['name'=>'birthday','title'=>'تاریخ تولد','value'=>auth()->user()->birthday,'disabled'=>false,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mt20">
                <?php echo $__env->make('share.forms.input',['name'=>'birthplace','title'=>'محل تولد','value'=>auth()->user()->birthplace,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'mobile','class'=>'dleft','title'=>'موبایل','value'=>auth()->user()->mobile,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'telephone','class'=>'dleft','title'=>'تلفن','value'=>auth()->user()->telephone,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix-md"></div>
            <div class="col-md-12">
                <?php echo $__env->make('share.forms.input',['name'=>'address','id'=>'address','title'=>'آدرس','value'=>auth()->user()->address,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix mb40"></div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'postalCode','class'=>'dleft','title'=>'کد پستی','value'=>auth()->user()->postalCode,'extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.select',['name'=>'education','title'=>'آخرین مدرک تحصیلی','options'=>['1'=>'زیر دیپلم','2'=>'دیپلم','3'=>'کاردانی','4'=>'کارشناسی','5'=>'کارشناسی ارشد','6'=>'دکتری'],'selected'=>auth()->user()->education,'extraFields'=>'autocomplete="off"'.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'fieldOfStudy','title'=>'آخرین رشته و گرایش','extraFields'=>'autocomplete="off"'.$disabled,'value'=>auth()->user()->fieldOfStudy], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="clearfix mb20"></div>

            <div class="col-md-4">
                <?php if($disabled != 'disabled'): ?>
                    <?php echo $__env->make('share.forms.file',['title'=>'عکس آخرین مدرک تحصیلی','name'=>'educationPicture','extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <?php if(auth()->user()->educationPicture): ?>
                    <a download="<?php echo e(auth()->user()->educationPicture); ?>" href="<?php echo e(asset(auth()->user()->educationPicture)); ?>">
                        <img class="img-raised center-block" height="100px" src="<?php echo e(asset(auth()->user()->educationPicture)); ?>" alt="">
                    </a>
                <?php endif; ?>
            </div>
            <div class="col-md-4">
                <?php if($disabled != 'disabled'): ?>
                    <?php echo $__env->make('share.forms.file',['title'=>'عکس پرسنلی','name'=>'personalPicture','extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <?php if(auth()->user()->personalPicture): ?>
                    <a download="<?php echo e(auth()->user()->personalPicture); ?>" href="<?php echo e(asset(auth()->user()->personalPicture)); ?>">
                        <img class="img-raised center-block" height="100px" src="<?php echo e(asset(auth()->user()->personalPicture)); ?>" alt="">
                    </a>
                <?php endif; ?>
            </div>
            <div class="col-md-4">
                <?php if($disabled != 'disabled'): ?>
                    <?php echo $__env->make('share.forms.file',['title'=>'کارت ملی','name'=>'nationalCardPicture','extraFields'=>'autocomplete="off" '.$disabled], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <?php if(auth()->user()->nationalCardPicture): ?>
                    <a download="<?php echo e(auth()->user()->nationalCardPicture); ?>" href="<?php echo e(asset(auth()->user()->nationalCardPicture)); ?>">
                        <img class="img-raised center-block" height="100px" src="<?php echo e(asset(auth()->user()->nationalCardPicture)); ?>" alt="">
                    </a>
                <?php endif; ?>
            </div>

            <div class="clearfix mb20"></div>
            <div>
                <input type="hidden" id="city_id" name="city_id" value="<?php echo e(auth()->user()->city_id); ?>">
                <input type="hidden" id="skill_id" name="skill_id" value="<?php echo e((isset($skill->id)?$skill->id:'')); ?>">
            </div>
            <div class="clearfix mt20"></div>
            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1" <?php echo e($disabled); ?>>ذخیره</button>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/vueselect/vueselect.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datePicker/persianDate.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datePicker/datePicker.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.farsiInput.js')); ?>"></script>

    <script>
        $(document).ready(function () {
            $("#birthday").pDatepicker({
                format : "YYYY/MM/DD",
                maxDate: new persianDate().valueOf(),
                initialValueType: 'gregorian'
            });

            $("#birthday").val('<?php echo e(toPersian(auth()->user()->birthday)); ?>')
            $('select').material_select();

            $(function () {
                $('#firstName').farsiInput();
                $('#lastName').farsiInput();
                $('#address').farsiInput();
                $('#fatherName').farsiInput();
                $('#accountName').farsiInput();
                $('#accountBankName').farsiInput();
            });

            // $('form').attr('autocomplete', 'off');
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el: '#app',
            data: {
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer <?php echo e(auth()->user()->api_token); ?>'}}),

                city: {
                    url: '/v1/region/city',
                    list:<?php echo (auth()->user()->city) ? auth()->user()->city()->with('state')->get() :'[]'; ?>,
                    selected:<?php echo (auth()->user()->city) ? auth()->user()->city()->with('state')->get() :'[]'; ?>,
                    query: '',
                    params: {},
                    data: [],
                    loading: false
                },


                state:{
                    url:'/v1/region/state',
                    list:<?php echo (auth()->user()->city) ? '['.auth()->user()->city->state.']' :'[]'; ?>,
                    selected:<?php echo (auth()->user()->city) ? '['.auth()->user()->city->state.']' :'[]'; ?>,
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                skill:{
                    url:'front/v1/skill/skill',
                    list:[<?php echo isset($skill->id)?$skill:''; ?>],
                    selected:[<?php echo isset($skill->id)?$skill:''; ?>],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                nationalCode:'<?php echo e(auth()->user()->nationalCode); ?>',
                validnationalCode:true
            },
            created: function () {
                if (this.city.selected.length == 0) {
                    this.search(null, 'city',{withstate: 1});
                }

                if (this.city.selected.length == 0) {
                    this.search(null, 'state');
                }

                if (this.skill.selected.length == 0) {
                    this.search(null, 'skill');
                }

            },
            methods: {
                checkNationalCode: function (code) {
                    var L = code.length;

                    if (L < 8 || parseInt(code, 10) == 0) return false;
                    code = ('0000' + code).substr(L + 4 - 10);
                    if (parseInt(code.substr(3, 6), 10) == 0) return false;
                    var c = parseInt(code.substr(9, 1), 10);
                    var s = 0;
                    for (var i = 0; i < 9; i++)
                        s += parseInt(code.substr(i, 1), 10) * (10 - i);
                    s = s % 11;
                    return (s < 2 && c == s) || (s >= 2 && c == (11 - s));
                    return true;
                },

                customLabel: function (element) {
                    return element.title;
                },
                cityLabel: function (element) {
                    return element.state.title+'/'+element.title;
                },
                search: function (query,field,extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                isMoreResult:function (field) {
                    return (this[field].data.current_page+1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch: {
                'role.selected': function () {
                    var output = [];
                    for (var i=0; i < this.role.selected.length ; i++){
                        output.push(this.role.selected[i]['id']);
                    }
                    document.getElementById('roles_id').value = JSON.stringify(output);
                },
                nationalCode: function () {
                    if (this.nationalCode === '') {
                        this.validnationalCode = true;
                    } else {
                        this.validnationalCode = this.checkNationalCode(this.nationalCode);
                    }
                },
                'state.selected': function () {
                    if (this.state.selected) {
                        this.search(null, 'city', {withstate: 1,state_id:this.state.selected.id});
                    } else {
                        this.city.list = [];
                        this.city.selected = [];
                        document.getElementById('city_id').value = null;
                    }
                },
                'city.selected': function () {
                    if (this.city.selected) {
                        document.getElementById('city_id').value = this.city.selected.id;
                    } else {
                        document.getElementById('city_id').value = null;
                    }
                },
                'skill.selected': function () {
                    if (this.skill.selected) {
                        document.getElementById('skill_id').value = this.skill.selected.id;
                    } else {
                        document.getElementById('skill_id').value = null;
                    }
                },
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/vueselect/vueselect.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datePicker/persianDatePicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datePicker/custom.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/work/emi/resources/views/user/profile/edit.blade.php ENDPATH**/ ?>