<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('admin.home')); ?>">صفحه اصلی</a></li>
                <li><a href="<?php echo e(route('admin.organization.organization.index')); ?>">لیست سازمان ها</a></li>
                <li class="active">ایجاد سازمان</li>
            </ol>
        </div>
    </div>

    <form method="post" action="<?php echo e(route('admin.organization.organization.store')); ?>" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد سازمان</span>
                <?php echo $__env->make('share.extra.back2',['route'=>route('admin.organization.organization.index')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-12 mb20">
                <label for="users">انتخاب مدیران</label>
                <multiselect id="users" v-model="user.selected" :options="user.list" @search-change="search($event,'user')" :custom-label="userLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="user.list.length > 0 && isMoreResult('user')"  @click="moreResult('user')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="user.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'admins_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-12 mb20">
                <label for="organizations">انتخاب سازمان</label>
                <multiselect id="organizations" v-model="organization.selected" :options="organization.list" @search-change="search($event,'organization')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="organization.list.length > 0 && isMoreResult('organization')"  @click="moreResult('organization')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="organization.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'admins_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'title','title'=>'نام سازمان'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mt40">
                <?php echo $__env->make('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.file',['name'=>'logo','title'=>'لوگو'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.file',['name'=>'picture','title'=>'عکس'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div>
                <input type="hidden" id="admins_id" name="admins_id">
                <input type="hidden" id="organization_id" name="parent_id">
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>

        </div>

    </form>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/vueselect/vueselect.js')); ?>"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer <?php echo e(auth()->user()->api_token); ?>'}}),

                user:{
                    url:'/v1/admin/users/user',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                organization: {
                    url: '/admin/organization/v1/organization',
                    list: [],
                    selected: [],
                    query: '',
                    params: {},
                    data: [],
                    loading: false
                }
            },
            created: function () {
                this.search(null, 'user');
                this.search(null, 'organization');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                userLabel: function (element) {
                    return element.id + ' - ' + element.firstName +' - ' + element.lastName;
                },


                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'user.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.user.selected.length; i++) {
                        output.push(this.user.selected[i]['id']);
                    }
                    document.getElementById('admins_id').value = JSON.stringify(output);
                },
                'organization.selected': function () {
                    if (this.organization.selected) {
                        document.getElementById('organization_id').value = this.organization.selected.id;
                    } else {
                        document.getElementById('organization_id').value = null;
                    }
                },
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/vueselect/vueselect.css')); ?>">
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/work/emi/resources/views/admin/Organization/organization/create.blade.php ENDPATH**/ ?>