<?php

Route::prefix('v1/admin')->middleware('auth:api')->namespace('Api\Admin')->group(function () {

    Route::get('acl/role', 'RoleController@index');
    Route::get('acl/role/{id}', 'RoleController@show');

    Route::get('users/user', 'UserController@index');
    Route::get('users/user/{id}', 'UserController@show');

    Route::get('tickets/department', 'TicketDepartmentController@index');
    Route::get('tickets/department/{id}', 'TicketDepartmentController@show');

});

Route::prefix('v1/region')->namespace('Api\Front\Region')->group(function () {

    // Country

    Route::get('country', 'countryController@index');
    Route::get('country/{id}', 'countryController@show');


    // State

    Route::get('state', 'stateController@index');
    Route::get('state/{id}', 'stateController@show');


    // City

    Route::get('city', 'cityController@index');
    Route::get('city/{id}', 'cityController@show');


    // Area

    Route::get('area', 'areaController@index');
    Route::get('area/{id}', 'areaController@show');

});
