<?php

Route::namespace('Front')->name('front.')->group(function () {

    Route::get('', function () {return view('front.home.back');})->name('home');


    Route::get('', 'HomeController@index')->name('home');

    Route::get('landing/{name}', 'LandingController@show')->name('landing');
    Route::get('skill', 'SkillController@index')->name('skill.index');

    Route::get('serviceoffer', 'serviceOfferController@index')->name('serviceOffer.index');
    Route::post('serviceoffer/{id}', 'serviceOfferController@store')->name('serviceOffer.store');

    Route::get('servicecategory', 'serviceCategoryController@index')->name('serviceCategory.index');
    Route::get('servicecategory/{id}', 'serviceCategoryController@show')->name('serviceCategory.show');


    Route::get('inquiry/cervicecard', 'inquiryServiceCardController@show')->name('inquiry.cervicecard.show');
    Route::post('inquiry/cervicecard', 'inquiryServiceCardController@store')->name('inquiry.cervicecard.store');


    Route::get('offer/click/{id}', 'ServiceClickController@click')->name('serviceOffer.click');

    Route::get('/expirehehe', 'HomeController@expire');


    Route::get('/request', 'requestController@index')->name('request.index');
    Route::post('/request', 'requestController@store')->name('request.store');


    Route::get('ref/{code}', 'HomeController@referalCode')->name('referalcode');
});


Route::prefix('auth')->namespace('customAuth')->middleware('guest','throttle:100,1')->group(function () {

    // Login
    Route::get('login', 'loginController@login')->name('auth.login');
    Route::post('login', 'loginController@loginPost')->name('auth.loginPost');


    // Register
    Route::get('register/step1', 'registerController@create')->name('auth.register.create');
    Route::post('register/step1', 'registerController@store')->name('auth.register.store');



    Route::post('auth/logout', 'customAuthController@logout')->name('auth.logout');
});


Route::prefix('auth/register/confirm')->middleware('auth')->namespace('customAuth')->group(function () {

    // Confirm Mobile
    Route::get('mobile', 'confirmMobileController@create')->name('auth.confirm.create');
    Route::post('mobile', 'confirmMobileController@store')->name('auth.confirm.store');
    Route::get('mobile/sms', 'confirmMobileController@sms')->name('auth.confirm.sms');

});


Route::post('auth/logout', 'customAuth\customAuthController@logout')->name('auth.logout');


Route::prefix('panel/user')->name('user.')->middleware(['auth','user'])->namespace('User')->group(function () {
    Route::get('home', 'panelController@index')->name('home');


    // Tickets

    Route::get('ticket/ticketmessages/messages/{id}', 'Ticket\TicketMessageController@indexMessage')->name('ticketmessages.indexMessage');
    Route::resource('ticket/tickets',           'Ticket\TicketController');
    Route::resource('ticket/ticketmessages',    'Ticket\TicketMessageController');
});

Route::get('payment/verify/{pin}', 'User\Order\paymentController@verify')->name('payment.verify');


