@extends('user.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('user.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('user.wallet.request.index')}}">کیف پول</a></li>
                <li class="active">درخواست برداشت از کیف پول</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('user.wallet.request.store')}}">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">درخواست برداشت از کیف پول</span>
            </div>

            <div class="col-md-12">
                @include('share.forms.input',['name'=>'amount','class'=>'dleft price','title'=>'مبلغ درخواستی (تومان)'])
            </div>

            <div class="clearfix mt20"></div>
            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-2">ذخیره</button>
            </div>
        </div>
    </form>
@endsection



@push('scripts')
    <script src="{{asset('assets/plugins/number/jquery.number.min.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('.price').number(true);
        });
    </script>

@endpush
