@extends('user.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('user.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('user.tickets.index')}}">لیست پیام ها</a></li>
                <li class="active">ایجاد پیام</li>
            </ol>
        </div>
    </div>

    <div class="row white z-depth-1 mt10">
        <div class="col-md-12">
            <span class="blue-grey darken-2 white-text title z-depth-2">پیام ها</span>
            @include('share.extra.back2',['route'=>route('user.tickets.index')])
        </div>

        <div class="clearfix mb20"></div>
        <div class="col-md-12">
            <h2 class="text-center">{{$ticket->title}}</h2>
            <p>{{$ticket->body}}</p>
            @if($ticket->pathFile)
                <a class="waves-effect waves-light btn mt10" href="{{asset($ticket->pathFile)}}" download><i class="material-icons right">attach_file</i>دانلود فایل</a>
            @endif
            <hr>
        </div>
        <div class="col-md-6">
            <p class=" text-center pd5 blue-grey darken-2 white-text br4 z-depth-1 mb10 mr10 quarter">{{$ticket->user->firstName.' '.$ticket->user->lastName}}</p>
        </div>
        <div class="col-md-6 text-left">
            <p class="text-center pd5 blue-grey darken-2 white-text br4 z-depth-1 mb10 mr10 half dleft right">{{toPersian($ticket->created_at)}}</p>
        </div>
    </div>

    @foreach($messages as $message)
        <div class="row white z-depth-1 mt20">
            <div class="col-md-12">
                <h2 class="text-center">{{$message->title}}</h2>
                <p>{{$message->body}}</p>
                @foreach($message->files as $file)
                    <a class="waves-effect waves-light btn mt10" href="{{asset($file->path)}}" download><i class="material-icons right">attach_file</i>دانلود فایل</a>
                @endforeach
                <hr>
            </div>
            <div class="col-md-4">
                <p class="text-center pd5 blue-grey darken-1 white-text br4 z-depth-1 mb10 col-md-6">{{$message->user->firstName.' '.$message->user->lastName}}</p>
            </div>
            <div class="col-md-4"></div>
            <div class="col-md-4 text-left">
                <p class="text-center pd5 blue-grey darken-2 white-text br4 z-depth-1 mb10 mr10 half dleft right">{{toPersian($message->created_at)}}</p>
            </div>
        </div>
    @endforeach

    <div class="row white z-depth-1 mt40">
        <form method="post" action="{{route('user.ticketmessages.store')}}" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ارسال پاسخ</span>
            </div>
            <div class="col-md-12">
                @include('share.forms.textarea-Material',['name'=>'body','title'=>'تیتر'])
            </div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'files[]','title'=>'اپلود فایل','multiple'=>true])
            </div>


            <div class="col-md-12 mb20 mt20">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>
            <div>
                <input type="hidden" name="ticket_id" value="{{$ticket->id}}">
            </div>

        </form>
    </div>

@endsection

@push('scripts')

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });
    </script>

@endpush

@push('styles')

    <style>
        hr {
            margin-top: 10px;
            margin-bottom: 10px;
        }
    </style>

@endpush