@extends('front.layouts.master')


@section('content')
    <div class="skillpage mt40 mb40">

        <div id="vue_app" class="container-fluid">

            <div class="row">

                @foreach($users->chunk(3) as $chunk)
                    @foreach($chunk as $user)
                        <div class="col-md-4">

                            <a href="#modal_{{$loop->index.$user->id}}">
                                <div class="card col-md-12 pd0">

                                    <div class="card-content col-md-12">

                                        <div class="col-md-12 mb20">
                                            <div class="col-md-6 pd0 text-center">
                                                <p class="skillField">نام</p>
                                            </div>
                                            <div class="col-md-6">
                                                <p class="skillValue">{{$user->firstName}}</p>
                                            </div>
                                        </div>

                                        <div class="col-md-12 mb20">
                                            <div class="col-md-6 pd0 text-center">
                                                <p class="skillField">نام خانوادگی</p>
                                            </div>
                                            <div class="col-md-6">
                                                <p class="skillValue">{{$user->lastName}}</p>
                                            </div>
                                        </div>

                                        <div class="col-md-12 mb20">
                                            <div class="col-md-6 pd0 text-center">
                                                <p class="skillField">شغل</p>
                                            </div>
                                            <div class="col-md-6">
                                                <p class="skillValue">{{$user->job}}</p>
                                            </div>
                                        </div>

                                        <div class="col-md-12 mb20">
                                            <div class="col-md-6 pd0 text-center">
                                                <p class="skillField">مهارت</p>
                                            </div>
                                            <div class="col-md-6">
                                                <p class="skillValue">{{(isset($user->skill[0])?$user->skill[0]->title:'ثبت نشده')}}</p>
                                            </div>
                                        </div>

                                </div>

                                    <div id="modal_{{$loop->index.$user->id}}" class="modal">
                                    <div class="modal-content text-right">

                                        <div class="col-md-12">
                                            <div class="card">
                                                <div class="card-content text-center text-center">

                                                    <p class="card-title activator grey-text text-darken-4 text-right">
                                                        <span>نام:</span>
                                                        <span>{{$user->firstName}}</span>
                                                    </p>
                                                    <p class="card-title activator grey-text text-darken-4 text-right">
                                                        <span>نام خانوادگی:</span>
                                                        <span>{{$user->lastName}}</span>
                                                    </p>
                                                    <p class="card-title activator grey-text text-darken-4 text-right">
                                                        <span>سن:</span>
                                                        <span>{{$user->getBirthday()}}</span>
                                                    </p>
                                                    <p class="card-title activator grey-text text-darken-4 text-right">
                                                        <span>شغل:</span>
                                                        <span>{{$user->job}}</span>
                                                    </p>
                                                      <p class="card-title activator grey-text text-darken-4 text-right">
                                                        <span>مهارت:</span>
                                                        <span>{{(isset($user->skill[0])?$user->skill[0]->title:'ثبت نشده')}}</span>
                                                    </p>


                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                </div>
                            </a>


                        </div>
                    @endforeach
                    <div class="clearfix"></div>
                @endforeach

                @if($users->count() == 0)
                    <div class="col-md-8 col-md-offset-2">
                        <div class="card text-center col-md-12 pd0">
                            <h1 class="mt20">نتیجه ای یافت نشد</h1>
                            <img src="{{asset('assets/img/notfound.gif')}}" alt="">
                            <a class="waves-effect waves-light btn quarter center-block blue darken-2 mt20 mb20" href="/">بازگشت به صفحه اصلی</a>
                        </div>
                    </div>
                @endif

            </div>

            <div class="row">
                <div class="col-md-12">
                    {!! $users->links() !!}
                </div>
            </div>


        </div>

    </div>
@endsection

@push('scripts')


    <script type="text/javascript">
        $(document).ready(function(){
            $('.modal').modal();
        });
    </script>

@endpush
