@extends('front.layouts.master')


@section('content')
    <div class="skillpage mt40 mb40">

        <div id="vue_app" class="container-fluid">

            <div class="row">
                <div class="col-md-12">
                    <br><br><br><br>
                </div>

                @foreach($offerDiscounts->chunk(4) as $chunk)
                    @foreach($chunk as $discount)
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="ticket col-xs-12 pd0">
                                <div class="ticket-card ticket-right col-xs-4">
                                    <img class="img-responsive" src="{{asset($discount->pictureApi)}}" alt="">
                                </div>
                                <div class="ticket-card ticket-left col-xs-8 pd0">
                                    <div class="col-xs-12 mt10 ticket-title">{{$discount->title}}</div>
                                    <div class="col-xs-12 pd10 red waves-effect waves-light mt10 discount_code_copy"></div>
                                    <div class="col-xs-12 mt10">
                                        <p>
                                            <span>مهلت استفاده تا </span>
                                            <span>{{toPersian($discount->expire)}}</span>
                                        </p>
                                    </div>
                                    <div class="col-xs-12 mt10 mb10 text-right">
                                        <a class=" waves-effect waves-light custom-btn2 white text-right" target="_blank" href="#modal_{{$loop->index.$discount->id}}">ورود به سایت</a>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="modal_{{$loop->index.$discount->id}}" class="modal">
                            <div class="modal-content">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-image waves-effect waves-block waves-light">
                                            <img class="img-responsive" src="{{asset($discount->pictureApi)}}">
                                        </div>
                                        <div class="card-content text-center">
                                            <span class="card-title activator grey-text text-darken-4 text-center">{{$discount->title}}</span>
                                            <p class="card-title activator grey-text text-darken-4 text-center">{{$discount->body}}</p>

                                            <form method="post" action="{{route('front.serviceOffer.store',$discount->id)}}">
                                                {{ csrf_field() }}
                                                @include('share.forms.input',['name'=>'mobile','class'=>'dleft','title'=>'موبایل خود را وارد کنید و هدیه بگیرید','extraFields'=>'required="on" '])
                                                <button class="waves-effect waves-light btn quarter center-block blue darken-2">دریافت هدیه</button>
                                            </form>

                                        </div>



                                        <div class="card-action text-center">
                                            <a class="waves-effect waves-light custom-btn" target="_blank" href="{{route('front.serviceOffer.click',$discount->id)}}">ورود به سایت</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    @endforeach
                    <div class="col-xs-12 mt20"></div>
                @endforeach

                @foreach($mopo->chunk(4) as $chunk)
                    @foreach($chunk as $discount)
                        @php $id = random_int(999,9999999) @endphp
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="ticket col-xs-12 pd0">
                                <div class="ticket-card ticket-right col-xs-4">
                                    <img class="img-responsive" src="{{asset($discount->logo)}}" alt="">
                                </div>
                                <div class="ticket-card ticket-left col-xs-8 pd0">
                                    <div class="col-xs-12 mt10 ticket-title">{{$discount->title}}</div>
                                    <div class="col-xs-12 pd10 red waves-effect waves-light mt10 discount_code_copy"></div>
                                    <div class="col-xs-12 mt10">
                                        <p>
                                            <span>مهلت استفاده تا </span>
                                            <span>{{$discount->valid_until}}</span>
                                        </p>
                                    </div>
                                    <div class="col-xs-12 mt10 mb10 text-right">
                                        <a class=" waves-effect waves-light custom-btn2 white text-right" target="_blank" href="#modal_{{$loop->index.$discount->id.$id}}">ورود به سایت</a>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="modal_{{$loop->index.$discount->id.$id}}" class="modal">
                            <div class="modal-content">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-image waves-effect waves-block waves-light">
                                            <img class="img-responsive" src="{{asset($discount->logo)}}">
                                        </div>
                                        <div class="card-content text-center">
                                            <span class="card-title activator grey-text text-darken-4 text-center">{{$discount->title}}</span>

                                            <form method="post" action="{{route('front.serviceOffer.store',[$discount->id,'mp'=>1])}}">
                                                {{ csrf_field() }}
                                                @include('share.forms.input',['name'=>'mobile','class'=>'dleft','title'=>'موبایل خود را وارد کنید و هدیه بگیرید','extraFields'=>'required="on" '])
                                                <input type="hidden" name="mp" value="{{$discount->id}}">
                                                <button class="waves-effect waves-light btn quarter center-block blue darken-2">دریافت هدیه</button>
                                            </form>

                                        </div>



                                        <div class="card-action text-center">
                                            <a class="waves-effect waves-light custom-btn" target="_blank" href="{{route('front.serviceOffer.click',$discount->id)}}">ورود به سایت</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    @endforeach
                    <div class="col-xs-12 mt20"></div>
                @endforeach

                @if($offerDiscounts->count() == 0)
                    <div class="col-md-8 col-md-offset-2">
                        <div class="card-panel">
                            <h4 class="text-center mt40 mb40">نتیجه ای یافت نشد</h4>
                        </div>
                    </div>
                @endif

                <div class="col-md-12">
                    <br><br><br><br>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    {!! $offerDiscounts->links() !!}
                </div>
            </div>

        </div>

    </div>
@endsection

@push('styles')

    <style>
        body {
            background-color: #ffffff !important;
        }
    </style>

@endpush

@push('scripts')

    <script type="text/javascript">
        $(document).ready(function(){
            $('.modal').modal();
        });
    </script>

@endpush
