@extends('front.layouts.master')

@section('content')
    <div class="container register" id="app">
        <div class="rw"></div>
        <div class="row">
            <br><br><br><br>

            <div class="col-md-6 text-center mb40">
                <h2>شرایط و ضوابط عضویت در باشگاه</h2>
            </div>
            <div class="col-md-6 text-center mb40">
                <h2>فرم ثبت نام</h2>
            </div>

            <div class="clearfix"></div>
            <div class="col-md-6 section-right">
                <div class="col-md-12">
                    <h4>
                        دریافت تخصص کارت با ارائه خدمات در سراسر کشور
                    </h4>
                </div>
                <div class="col-md-12">
                    <h4>
                        ( جهت استفاده از خدمات رفاهی و علمی )
                    </h4>
                </div>
                <div class="col-md-12">
                    <h4>
                        بخشی از خدمات تخصص کارت :
                    </h4>
                </div>
                <div class="col-md-12">
                    <ul>
                        <li>معرفی ایده پرداز به مجری</li>
                        <li>ثبت رزومه تخصصی</li>
                        <li>بهره مندی از خدمات رفاهی و درمانی</li>
                        <li>ایجاد بستر در تجاری سازی ایده ها</li>
                        <li>کمک به ایجاد و توسعه طرح های فناور مخترعین</li>
                        <li>بهره مندی از تخفیفات ویژه دوره های آموزشی در سراسر کشور</li>
                        <li>بهره مندی از تخفیفات ویژه رویدادهای ملی و بین المللی</li>
                        <li>بهرمندی از خدمات مشاوره تخصصی توسعه کسب و کار و کارآفرینی</li>
                        <li>بهره مندی از خدمات برندینگ و توسعه</li>
                        <li>کسب و کار</li>
                    </ul>
                </div>
            </div>

            <div class="col-md-6 auth-login">
                <form class="form-horizontal" role="form" method="POST" action="{{ route('auth.registerPost.step2')}}" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="card">
                        <div class="card-content row">

                            <div class="col-md-12 mt25 register-steps">
                                <div class="col-md-4 pd0 text-center ">
                                    <span class="step-number">1</span>
                                    <p>اطلاعات فردی</p>
                                </div>
                                <div class="col-md-4 pd0 text-center active">
                                    <span class="step-number">2</span>
                                    <p>اطلاعات تماس</p>
                                </div>
                                <div class="col-md-4 pd0 text-center">
                                    <span class="step-number">3</span>
                                    <p>تحصیلات و مهارت</p>
                                </div>
                            </div>
                            <div class="col-md-12 mt20"></div>

                            <div class="col-md-12">
                                @include('share.forms.input',['name'=>'address','title'=>'آدرس','extraFields'=>'autocomplete="off"'])
                            </div>
                            <div class="clearfix"></div>


                            <div class="col-md-6">
                                <label for="states">انتخاب استان محل سکونت</label>
                                <multiselect id="states" v-model="state.selected" :options="state.list" @search-change="search($event,'state')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                <span v-if="state.list.length > 0 && isMoreResult('state')"  @click="moreResult('state')" class="waves-effect waves-light btn  center-block teal darken-2 mt20" slot="afterList">
                                    <span v-if="state.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                    <span v-else>موارد بیشتر</span>
                                </span>
                                </multiselect>
                            </div>
                            <div class="col-md-6">
                                <label for="cities">انتخاب شهر محل سکونت</label>
                                <multiselect id="cities" v-model="city.selected" :options="city.list" @search-change="search($event,'city',{withstate:1,state:state.selected.id})" :custom-label="cityLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                <span v-if="city.list.length > 0 && isMoreResult('city')"  @click="moreResult('city')" class="waves-effect waves-light btn  center-block teal darken-2 mt20" slot="afterList">
                                    <span v-if="city.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                    <span v-else>موارد بیشتر</span>
                                </span>
                                </multiselect>
                                @include('share.forms.error',['name'=>'city_id'])
                            </div>
                            <div class="clearfix"></div>


                            <div class="col-md-6">
                                @include('share.forms.input',['name'=>'mobile','title'=>'موبایل','class'=>'dleft','extraFields'=>'autocomplete="off"'])
                            </div>
                            <div class="col-md-6">
                                @include('share.forms.input',['name'=>'telephone','title'=>'تلفن','class'=>'dleft','extraFields'=>'autocomplete="off"'])
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                @include('share.forms.input',['name'=>'email','title'=>'ایمیل','class'=>'dleft','extraFields'=>'autocomplete="off"'])
                            </div>
                            <div class="col-md-6">
                                @include('share.forms.input',['name'=>'postalCode','title'=>'کد پستی','class'=>'dleft','extraFields'=>'autocomplete="off"'])
                            </div>

                            <div>
                                <input type="hidden" id="city_id" name="city_id">
                            </div>

                        </div>
                        <div class="card-action">
                            <button style="background-color: #1e2945 !important;" class="waves-effect waves-light btn center-block half blue" type="submit">
                                مرحله بعد
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection


@push('scripts')

    <script src="{{asset('assets/plugins/datePicker/persianDate.js')}}"></script>
    <script src="{{asset('assets/plugins/datePicker/datePicker.js')}}"></script>
    <script src="{{asset('assets/js/vue.js')}}"></script>
    <script src="{{asset('assets/js/axios.js')}}"></script>
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>
    <script src="{{asset('assets/js/jquery.farsiInput.js')}}"></script>

    <script>
      $(document).ready(function () {
          $("#birthday").pDatepicker({
              format : "YYYY/MM/DD",
              maxDate: new persianDate().valueOf(),
              initialValueType: 'gregorian'
          });
          $("#birthday").val(null);

          $('select').material_select();

          $(function () {
              $('#firstName').farsiInput();
              $('#lastName').farsiInput();
              $('#fatherName').farsiInput();
          });

      });

      Vue.component('Multiselect', VueMultiselect.default);
      vm = new Vue({
          el:'#app',
          data:{
              ax:axios.create({baseURL: baseUrl}),

              state:{
                  url:'/v1/region/state',
                  list:[],
                  selected:[],
                  query:'',
                  params:{},
                  data:[],
                  loading:false
              },

              city:{
                  url:'/v1/region/city',
                  list:[],
                  selected:[],
                  query:'',
                  params:{},
                  data:[],
                  loading:false
              },
              skill:{
                  url:'front/v1/skill/skill',
                  list:[],
                  selected:[],
                  query:'',
                  params:{},
                  data:[],
                  loading:false
              },

          },
          created:function () {
              this.search(null, 'state');
              this.search(null, 'skill');
          },
          methods:{
              cityLabel: function (element) {
                  return element.state.title+'/'+element.title;
              },

              search: function (query,field,extraQuery = {}) {
                  this[field].params = extraQuery;
                  if (query) {
                      this[field].params.query = query;
                  }

                  if (query !== '' || query === null) {
                      this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                          this[field].query = query;
                          this[field].list = response.data.data;
                          this[field].data = response.data;
                      }.bind(this));
                  }
              },
              customLabel: function (element) {
                  return element.title;
              },
              isMoreResult:function (field) {
                  return (this[field].data.current_page+1 <= this[field].data.last_page);
              },
              moreResult:function (field) {
                  if (this.isMoreResult(field)) {
                      this[field].loading = true;
                      this[field].params.page = this[field].data.current_page + 1;

                      this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                          this[field].list = this[field].list.concat(response.data.data);
                          this[field].data = response.data;
                          this[field].loading = false;
                      }.bind(this));
                  }
              }
          },
          watch: {
              'state.selected': function () {
                  if (this.state.selected) {
                      this.search(null, 'city', {withstate: 1,state_id:this.state.selected.id});
                  } else {
                      this.city.list = [];
                      this.city.selected = [];
                      document.getElementById('city_id').value = null;
                  }
              },
              'city.selected': function () {
                  if (this.city.selected) {
                      document.getElementById('city_id').value = this.city.selected.id;
                  } else {
                      document.getElementById('city_id').value = null;
                  }
              },
              'skill.selected': function () {
                  if (this.skill.selected) {
                      document.getElementById('skill_id').value = this.skill.selected.id;
                  } else {
                      document.getElementById('skill_id').value = null;
                  }
              },
          }
      });
  </script>
@endpush


@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/persianDatePicker.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/custom.css')}}" />
@endpush
