@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.users.index')}}">لیست کاربران</a></li>
                <li class="active">ویرایش کاربر</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.users.update',$user->id)}}" enctype="multipart/form-data">
        <input type="hidden" name="_method" value="PUT">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش کاربر</span>
                @include('share.extra.back2',['route'=>route('admin.users.index')])
            </div>


            <div class="col-md-6">
                @include('share.forms.input',['name'=>'userName','class'=>'dleft','title'=>'نام کاربری','value'=>$user->userName])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'email','class'=>'dleft','title'=>'ایمیل','value'=>$user->email])
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6">
                @include('share.forms.input',['name'=>'firstName','title'=>'نام','value'=>$user->firstName])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'lastName','title'=>'نام خانوادگی','value'=>$user->lastName])
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6">
                @include('share.forms.input',['name'=>'fatherName','title'=>'نام پدر','value'=>$user->fatherName])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'gender','title'=>'جنسیت','options'=>['male'=>'مرد','female'=>'زن'],'selected'=>$user->gender])
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6 mb20">
                <label for="states">انتخاب استان محل سکونت</label>
                <multiselect id="states" v-model="state.selected" :options="state.list" @search-change="search($event,'state',{withstate:1})" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                    <span v-if="state.list.length > 0 && isMoreResult('state')"  @click="moreResult('state')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                        <span v-if="state.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                        <span v-else>موارد بیشتر</span>
                    </span>
                </multiselect>
                @include('share.forms.error',['name'=>'city_id'])
            </div>
            <div class="col-md-6 mb20">
                <label for="cities">انتخاب شهر محل سکونت</label>
                <multiselect id="cities" v-model="city.selected" :options="city.list" @search-change="search($event,'city',{withstate:1})" :custom-label="cityLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                    <span v-if="city.list.length > 0 && isMoreResult('city')"  @click="moreResult('city')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                        <span v-if="city.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                        <span v-else>موارد بیشتر</span>
                    </span>
                </multiselect>
                @include('share.forms.error',['name'=>'city_id'])
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6 ">
                    @include('share.forms.input',['name'=>'nationalCode','class'=>'dleft','title'=>'کد ملی',
                  'extraFields'=>'v-model="nationalCode" :class="{invalid:!validnationalCode}"','value'=>$user->nationalCode])
                    <span v-if="!validnationalCode" class="error-block">کد ملی صحیح نیست</span>
                @include('share.forms.error',['name'=>'nationalCode'])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'certificateCode','title'=>'شماره شناسنامه','value'=>$user->certificateCode])
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6">
                @include('share.forms.date',['name'=>'birthday','title'=>'تاریخ تولد','value'=>$user->birthday,'disabled'=>false])
            </div>
            <div class="col-md-6 mt20">
                @include('share.forms.input',['name'=>'birthplace','title'=>'محل تولد','value'=>$user->birthplace])
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-6">
                @include('share.forms.input',['name'=>'mobile','class'=>'dleft','title'=>'موبایل','value'=>$user->mobile])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'telephone','class'=>'dleft','title'=>'تلفن','value'=>$user->telephone])
            </div>
            <div class="clearfix-md"></div>


            <div class="col-md-12">
                @include('share.forms.input',['name'=>'address','title'=>'آدرس','value'=>$user->address])
            </div>
            <div class="clearfix-md mb20"></div>

            <div class="col-md-6">
                @include('share.forms.input',['name'=>'postalCode','class'=>'dleft','title'=>'کد پستی','value'=>$user->postalCode])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'type','title'=>'نوع کاربر','options'=>['admin'=>'مدیر','user'=>'کاربر'],'selected'=>$user->type])
            </div>
            <div class="clearfix mb20"></div>

            <div class="col-md-12 mb20">
                <label for="skills">انتخاب مهارت</label>
                <multiselect id="skills" v-model="skill.selected" :options="skill.list" @search-change="search($event,'skill')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                <span v-if="skill.list.length > 0 && isMoreResult('skill')"  @click="moreResult('skill')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                                    <span v-if="skill.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                    <span v-else>موارد بیشتر</span>
                                </span>
                </multiselect>
                @include('share.forms.error',['name'=>'skill_id'])
            </div>

            <div class="col-md-3 mt20">
                @include('share.forms.switch',['name'=>'canEdit','title'=>'قابل ویرایش','checked'=>$user->canEdit])
            </div>
            <div class="col-md-3 mt20">
                @include('share.forms.switch',['name'=>'saveSkill','title'=>'ثبت مهارت در سامانه','checked'=>$user->saveSkill])
            </div>
            <div class="col-md-3">
                @include('share.forms.select',['name'=>'education','title'=>'آخرین مدرک تحصیلی','options'=>['1'=>'زیر دیپلم','2'=>'دیپلم','3'=>'کاردانی','4'=>'کارشناسی','5'=>'کارشناسی ارشد','6'=>'دکتری'],'selected'=>$user->education,'extraFields'=>'autocomplete="off"'])
            </div>
            <div class="col-md-3">
                @include('share.forms.input',['name'=>'fieldOfStudy','title'=>'آخرین رشته و گرایش','extraFields'=>'autocomplete="off"','value'=>$user->fieldOfStudy])
            </div>
            <div class="clearfix mb20"></div>


            <div class="col-md-12">
                @include('share.forms.input',['name'=>'password','class'=>'dleft','title'=>'پسورد'])
            </div>

            <div class="col-md-12 mb20">
                <br><br>
                <hr>
                <label for="roles">سطح دسترسی</label>
                <multiselect id="roles" v-model="role.selected" :options="role.list" @search-change="search($event,'role')" :multiple="true" :close-on-select="false" :custom-label="roleLabel" track-by="id" :internal-search="false">
                        <span v-if="role.list.length > 0 && isMoreResult('role')"  @click="moreResult('role')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="role.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>More Result</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'roles_id'])
            </div>

            <div class="clearfix mb20"></div>
            <div class="col-md-4">
                @include('share.forms.file',['title'=>'عکس آخرین مدرک تحصیلی','name'=>'educationPicture'])
                @if($user->educationPicture)
                    <a download="{{$user->educationPicture}}" href="{{asset($user->educationPicture)}}">
                        <img class="img-raised center-block" height="100px" src="{{asset($user->educationPicture)}}" alt="">
                    </a>
                @endif
            </div>
            <div class="col-md-4">
                @include('share.forms.file',['title'=>'عکس پرسنلی','name'=>'personalPicture'])
                @if($user->personalPicture)
                    <a download="{{$user->personalPicture}}" href="{{asset($user->personalPicture)}}">
                        <img class="img-raised center-block" height="100px" src="{{asset($user->personalPicture)}}" alt="">
                    </a>
                @endif
            </div>
            <div class="col-md-4">
                @include('share.forms.file',['title'=>'کارت ملی','name'=>'nationalCardPicture'])
                @if($user->nationalCardPicture)
                    <a download="{{$user->nationalCardPicture}}" href="{{asset($user->nationalCardPicture)}}">
                        <img class="img-raised center-block" height="100px" src="{{asset($user->nationalCardPicture)}}" alt="">
                    </a>
                @endif
            </div>
            <div class="clearfix mb20"></div>

            <div class="clearfix mt20"></div>
            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-2">ذخیره</button>
            </div>
            <div>
                <input type="hidden" id="roles_id" name="roles_id" value="{{$user->role->pluck('id')}}" >
                <input type="hidden" id="city_id" name="city_id" value="{{$user->city_id}}">
                <input type="hidden" id="skill_id" name="skill_id" value="{{(isset($skill->id)?$skill->id:'')}}">
            </div>
        </div>
    </form>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>
    <script src="{{asset('assets/plugins/datePicker/persianDate.js')}}"></script>
    <script src="{{asset('assets/plugins/datePicker/datePicker.js')}}"></script>

    <script>
        $(document).ready(function () {
            $("#birthday").pDatepicker({
                format : "YYYY/MM/DD",
                maxDate: new persianDate().valueOf(),
                initialValueType: 'gregorian'
            });

            $("#birthday").val('{{toPersian($user->birthday)}}')
            $('select').material_select();
        });
    </script>


    <script>
        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el: '#app',
            data: {
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                role:{
                    url:'/v1/admin/acl/role',
                    list:{!! $user->role !!},
                    selected:{!! $user->role !!},
                    query:'',
                    data:[],
                    loading:false
                },

                city:{
                    url:'/v1/region/city',
                    list:{!! ($user->city) ? '['.$user->city.']' :'[]' !!},
                    selected:{!! ($user->city) ? '['.$user->city.']' :'[]' !!},
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                state:{
                    url:'/v1/region/state',
                    list:{!! ($user->city) ? '['.$user->city->state.']' :'[]' !!},
                    selected:{!! ($user->city) ? '['.$user->city->state.']' :'[]' !!},
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                skill:{
                    url:'front/v1/skill/skill',
                    list:[{!! isset($skill->id)?$skill:'' !!}],
                    selected:[{!! isset($skill->id)?$skill:'' !!}],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                nationalCode:'{{$user->nationalCode}}',
                validnationalCode:true
            },
            created: function () {
                if (this.city.selected.length == 0) {
                    this.search(null, 'city',{withstate: 1});
                }

                if (this.city.selected.length == 0) {
                    this.search(null, 'state');
                }

                if (this.skill.selected.length == 0) {
                    this.search(null, 'skill');
                }

                if (this.role.selected.length == 0) {
                    this.search(null, 'role');
                }
            },
            methods: {
                checkNationalCode: function (code) {
                    var L = code.length;

                    if (L < 8 || parseInt(code, 10) == 0) return false;
                    code = ('0000' + code).substr(L + 4 - 10);
                    if (parseInt(code.substr(3, 6), 10) == 0) return false;
                    var c = parseInt(code.substr(9, 1), 10);
                    var s = 0;
                    for (var i = 0; i < 9; i++)
                        s += parseInt(code.substr(i, 1), 10) * (10 - i);
                    s = s % 11;
                    return (s < 2 && c == s) || (s >= 2 && c == (11 - s));
                    return true;
                },


                cityLabel: function (element) {
                    if (element.state) {
                        return element.state.title+'/'+element.title;
                    }
                    return element.title;
                },
                roleLabel: function (element) {
                    return element.name;
                },
                search: function (query,field,extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.title;
                },
                isMoreResult:function (field) {
                    return (this[field].data.current_page+1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                },
            },
            watch: {
                'role.selected': function () {
                    var output = [];
                    for (var i=0; i < this.role.selected.length ; i++){
                        output.push(this.role.selected[i]['id']);
                    }
                    document.getElementById('roles_id').value = JSON.stringify(output);
                },
                nationalCode: function () {
                    if (this.nationalCode === '') {
                        this.validnationalCode = true;
                    } else {
                        this.validnationalCode = this.checkNationalCode(this.nationalCode);
                    }
                },
                'state.selected': function () {
                    if (this.state.selected) {
                        this.search(null, 'city', {withstate: 1,state_id:this.state.selected.id});
                    } else {
                        this.city.list = [];
                        this.city.selected = [];
                        document.getElementById('city_id').value = null;
                    }
                },
                'city.selected': function () {
                    if (this.city.selected) {
                        document.getElementById('city_id').value = this.city.selected.id;
                    } else {
                        document.getElementById('city_id').value = null;
                    }
                },
                'skill.selected': function () {
                    if (this.skill.selected) {
                        document.getElementById('skill_id').value = this.skill.selected.id;
                    } else {
                        document.getElementById('skill_id').value = null;
                    }
                },
            }
        });
    </script>
@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/persianDatePicker.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/custom.css')}}" />
@endpush
