@extends('admin.layout.master')

@section('content')
<div class="row">

    <div class="row">
        <div class="col-md-12">
            <h4>کاربران</h4>
            <hr>
        </div>
        <div class="clearfix"></div>

        <div class="col-md-3">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>تعداد کاربران</h2>
                    <p>{{number_format($users)}}</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-users sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>تعداد مدیران</h2>
                    <p>{{number_format($admins)}}</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-user-secret sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>کاربران جدید</h2>
                    <p>{{number_format($newUsers)}}</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-user-plus sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>مدیران جدید</h2>
                    <p>{{number_format($newAdmins)}}</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-user-plus sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
    </div>

{{--    <div class="row mt20">--}}
{{--        <div class="col-md-12">--}}
{{--            <h4>خدمات</h4>--}}
{{--            <hr>--}}
{{--        </div>--}}
{{--        <div class="clearfix"></div>--}}
{{--        <div class="col-md-3">--}}
{{--            <div class="card-panel row home-panel">--}}
{{--                <div class="col-md-8">--}}
{{--                    <h2>تعداد دپارتمان</h2>--}}
{{--                    <p>{{number_format($serviceDepartment)}}</p>--}}
{{--                </div>--}}
{{--                <div class="col-md-4 text-center">--}}
{{--                    <i class="fa fa-users sorange-bg" aria-hidden="true"></i>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--        <div class="col-md-3">--}}
{{--            <div class="card-panel row home-panel">--}}
{{--                <div class="col-md-8">--}}
{{--                    <h2>تعداد دسته بندی</h2>--}}
{{--                    <p>{{number_format($serviceCategory)}}</p>--}}
{{--                </div>--}}
{{--                <div class="col-md-4 text-center">--}}
{{--                    <i class="fa fa-user-secret sorange-bg" aria-hidden="true"></i>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--        <div class="col-md-3">--}}
{{--            <div class="card-panel row home-panel">--}}
{{--                <div class="col-md-8">--}}
{{--                    <h2>تعداد خدمات</h2>--}}
{{--                    <p>{{number_format($serviceOffer)}}</p>--}}
{{--                </div>--}}
{{--                <div class="col-md-4 text-center">--}}
{{--                    <i class="fa fa-user-plus sorange-bg" aria-hidden="true"></i>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--        <div class="col-md-3">--}}
{{--            <div class="card-panel row home-panel">--}}
{{--                <div class="col-md-8">--}}
{{--                    <h2>تعداد کارت</h2>--}}
{{--                    <p>{{number_format($serviceCard)}}</p>--}}
{{--                </div>--}}
{{--                <div class="col-md-4 text-center">--}}
{{--                    <i class="fa fa-user-plus sorange-bg" aria-hidden="true"></i>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--    </div>--}}

    <div class="row mt20">
        <div class="col-md-12">
            <h4>تیکت ها</h4>
            <hr>
        </div>
        <div class="clearfix"></div>

        <div class="col-lg-3 col-md-6">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>باز</h2>
                    <p>{{number_format($ticketOpen)}}</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-comments sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>بسته</h2>
                    <p>{{number_format($ticketClose)}}</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-comments sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>در حال پیگیری</h2>
                    <p>{{number_format($ticketPending)}}</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-comments sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>غیر فعال</h2>
                    <p>{{number_format($ticketDeactive)}}</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-comments sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt20">
        <div class="col-md-6">
            <div class="boxshadow-1 pd10">
                <canvas id="userChart" width="400" height="200"></canvas>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card-panel">
                <canvas id="userServiceCardChart"></canvas>
            </div>
        </div>
    </div>


</div>
@endsection


@push('scripts')
    <script src="{{asset('assets/js/chartjs.js')}}"></script>
    <script>

        var ctx = document.getElementById("userChart").getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: {!! $userChart->pluck('day') !!},
                datasets: [{
                    label: "ثبت نام کاربران {{toPersian(today(),'Y')}} ",
                    data:{!! $userChart->pluck('user_count') !!},
                    backgroundColor: '#03a9f4',
                    borderColor:'#03a9f4',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero:true
                        }
                    }]
                }
            }
        });


        var ctx2 = document.getElementById("userServiceCardChart").getContext('2d');
        var myChart = new Chart(ctx2, {
            type: 'bar',
            data: {
                labels: {!! $userServiceCardChart->pluck('day') !!},
                datasets: [{
                    label: 'کارت های خریداری شده',
                    data:{!! $userServiceCardChart->pluck('user_count') !!},
                    backgroundColor: '#03a9f4',
                    borderColor:'#03a9f4',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero:true
                        }
                    }]
                }
            }
        });

    </script>

@endpush


@push('styles')

    <style>
        .panel-title::before {
            content: "";
            position: absolute;
            right: 0;
            left: -40px;
            bottom: 0;
            background-color: #ef5661;
            height: 1px;
            z-index: 1;
        }

        .boxshadow-1 {
            box-shadow: 0 0 2rem 0 rgba(136,152,170,.15) !important;
        }
    </style>

@endpush
