@extends('admin.layout.master')

@section('content')
    <form method="post" action="{{route('admin.roles.store')}}">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد سطح دسترسی</span>
                @include('share.extra.back2',['route'=>route('admin.roles.index')])
            </div>
            <div class="col-md-12">
                @include('share.forms.input',['name'=>'name','title'=>'تیتر'])
            </div>
            @foreach($permissions->groupBy('mainGroup') as $key1 => $var1)
                <div class="col-md-12 mb20">
                    <label for="">{{$key1}}</label>
                    <select class="select2" name="permissions[]" multiple="multiple">
                        @foreach($var1->groupBy('group') as $key2 => $var2)
                            <optgroup label="{{$key2}}">
                                @foreach($var2 as $permission)
                                    <option value="{{$permission->id}}">{{$permission->label}}</option>
                                @endforeach
                            </optgroup>
                        @endforeach
                    </select>
                </div>
            @endforeach

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>
        </div>
    </form>
@endsection

@push('scripts')
<script src="{{asset('assets/plugins/select2/select2.js')}}"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2({
            dir: 'rtl',
            multiple:true,
            closeOnSelect:false
        });
    });

</script>
@endpush
@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/select2/select2.css')}}">
@endpush