@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.wallet.wallet.index')}}">لیست کیف پول</a></li>
                <li class="active">ایجاد کیف پول</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.wallet.wallet.store')}}">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد کیف پول</span>
                @include('share.extra.back2',['route'=>route('admin.wallet.wallet.index')])
            </div>


            <div class="col-md-6">
                <label for="users">انتخاب کاربر</label>
                <multiselect id="users" v-model="user.selected" :options="user.list" @search-change="search($event,'user')" :custom-label="userLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="user.list.length > 0 && isMoreResult('user')"  @click="moreResult('user')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="user.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'user_id'])
            </div>

            <div class="col-md-6 mt20">
                @include('share.forms.input',['name'=>'amount','class'=>'dleft price','title'=>'موجودی (تومان)'])
            </div>

            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>true])
            </div>

            <div>
                <input type="hidden" id="user_id" name="user_id">
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>

        </div>

    </form>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/number/jquery.number.min.js')}}"></script>
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('.price').number(true);
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                user:{
                    url:'/v1/admin/users/user',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                if (this.user.selected.length == 0) {
                    this.search(null, 'user');
                }
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                userLabel: function (element) {
                    return element.id + ' - ' + element.firstName + ' - ' + element.lastName;
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'user.selected': function () {
                    if (this.user.selected) {
                        document.getElementById('user_id').value = this.user.selected.id;
                    } else {
                        document.getElementById('user_id').value = null;
                    }
                },
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush
