@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('user.wallet.request.index')}}">لیست درخواست تسویه حساب کیف پول</a></li>
                <li class="active">نمایش درخواست تسویه حساب کیف پول</li>
            </ol>
        </div>
    </div>


    <div class="row white z-depth-1">
        <div class="col-md-12 por">
            <span class="blue-grey darken-2 white-text title z-depth-2">نمایش درخواست کیف پول</span>
            <a href="{{route('user.wallet.request.index')}}" class="waves-effect waves-light btn blue darken-1 back-button"><i class="material-icons right">arrow_forward</i>بازگشت</a>
        </div>

        <div class="col-md-12">
            <h4>مشخصات کاربر</h4>
            <hr>
        </div>
        @if($request->wallet->model_type == 'App\User')
            <div class="col-md-3">
                <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">شناسه کاربر</h4>
                <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$request->wallet->model_id}}</p>
            </div>
            <div class="col-md-3">
                <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">ایمیل کاربر</h4>
                <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$request->wallet->model->email}}</p>
            </div>
            <div class="col-md-3">
                <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام کاربر</h4>
                <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$request->wallet->model->firstName}}</p>
            </div>
            <div class="col-md-3">
                <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام خانوادگی کاربر</h4>
                <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$request->wallet->model->lastName}}</p>
            </div>
        @else
            <div class="col-md-6">
                <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">شناسه سازمان</h4>
                <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$request->model_id}}</p>
            </div>
            <div class="col-md-6">
                <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">تیتر سازمان</h4>
                <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$request->model->title}}</p>
            </div>
        @endif
        <div class="clearfix mb20"></div>

        <div class="col-md-12">
            <h4>مشخصات کیف پول</h4>
            <hr>
        </div>
        <div class="col-md-4">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">موجودی (تومان)</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{number_format($request->wallet->amount)}}</p>
        </div>
        <div class="col-md-4">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">برداشت (تومان)</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{number_format($request->wallet->withdraw)}}</p>
        </div>
        <div class="col-md-4">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">واریز (تومان)</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{number_format($request->wallet->deposit)}}</p>
        </div>
        <div class="clearfix mb20"></div>
        <div class="col-md-12">
            <h4>مشخصات درخواست</h4>
            <hr>
        </div>

        <div class="col-md-6">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">مبلغ درخواستی (تومان)</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{number_format($request->amount)}}</p>
        </div>
        <div class="col-md-6">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">وضعیت درخواست</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$request->statusApi}}</p>
        </div>

        @if($request->body)
            <div class="col-md-12 mt10">
                <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">توضیحات</h4>
                <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$request->body}}</p>
            </div>
        @endif

        <div class="clearfix mb20"></div>


    </div>
@endsection

@push('scripts')

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });
    </script>

@endpush
