@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.tickets.index')}}">لیست مدیریت پیام ها</a></li>
                <li class="active">لیست مدیریت پیام ها</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.tickets.store')}}" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد پیام</span>
                @include('share.extra.back2',['route'=>route('admin.tickets.index')])
            </div>

            <div class="col-md-6">
                <label for="departments">انتخاب دپارتمان</label>
                <multiselect id="departments" v-model="department.selected" :options="department.list" @search-change="search($event,'department')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="department.list.length > 0 && isMoreResult('department')"  @click="moreResult('department')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="department.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'department_id'])
            </div>
            <div class="col-md-12">
                <label for="users">انتخاب کاربران</label>
                <multiselect id="users" v-model="user.selected" :options="user.list" @search-change="search($event,'user')" :custom-label="userLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="user.list.length > 0 && isMoreResult('user')"  @click="moreResult('user')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="user.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'user_id'])
            </div>
            <div class="clearfix mb20"></div>
            <div class="col-md-12 mb20">
                <label for="admins">انتخاب مدیران</label>
                <multiselect id="admins" v-model="admin.selected" :options="admin.list" @search-change="search($event,'admin',{isAdmin:1})" :custom-label="userLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="admin.list.length > 0 && isMoreResult('admin')"  @click="moreResult('admin')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="admin.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'admins_id'])
            </div>
            <div class="col-md-12">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر'])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'priority','title'=>'اولویت','options'=>['urgent'=>'فوری','high'=>'بالا','medium'=>'متوسط','low'=>'پایین']])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'status','title'=>'وضعیت','options'=>['open'=>'باز','pending'=>'در حال بررسی','close'=>'بسته','deactive'=>'غیر فعال']])
            </div>
            <div class="col-md-12">
                @include('share.forms.textarea-Material',['name'=>'body','title'=>'توضیحات'])
            </div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'file','title'=>'آپلود فایل'])
            </div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'excel','title'=>'ارسال پیام از طریق فایل اکسل'])
            </div>

            <div class="col-md-12 mb20 mt20">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>
            <div>
                <input type="hidden" id="department_id" name="department_id">
                <input type="hidden" id="user_id" name="user_id">
                <input type="hidden" id="admins_id" name="admins_id">
            </div>

        </div>
    </form>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                department:{
                    url:'/v1/admin/tickets/department',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
                user:{
                    url:'/v1/admin/users/user',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
                admin:{
                    url:'/v1/admin/users/user',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created:function () {
                this.search(null, 'department', {});
                this.search(null, 'admin', {isAdmin:1});
                this.search(null, 'user', {});
            },
            methods:{
                userLabel: function (element) {
                    return element.id + ' - ' + element.firstName + ' - ' + element.lastName;
                },

                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch: {
                'department.selected': function () {
                    if (this.department.selected) {
                        document.getElementById('department_id').value = this.department.selected.id;
                    } else {
                        document.getElementById('department_id').value = null;
                    }
                },
                'admin.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.admin.selected.length; i++) {
                        output.push(this.admin.selected[i]['id']);
                    }
                    document.getElementById('admins_id').value = JSON.stringify(output);
                },
                'user.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.user.selected.length; i++) {
                        output.push(this.user.selected[i]['id']);
                    }
                    document.getElementById('user_id').value = JSON.stringify(output);
                }
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush
