@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.skill.skill.index')}}">لیست سرویس ها</a></li>
                <li class="active">ایجاد مهارت</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.skill.skill.store')}}">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد مهارت</span>
                @include('share.extra.back2',['route'=>route('admin.skill.skill.index')])
            </div>

            <div class="col-md-12 mb20">
                <label for="categories">انتخاب دسته بندی</label>
                <multiselect id="categories" v-model="category.selected" :options="category.list" @search-change="search($event,'category')" :custom-label="customLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="category.list.length > 0 && isMoreResult('category')"  @click="moreResult('category')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="category.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'admins_id'])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر'])
            </div>
            <div class="col-md-6 mt40">
                @include('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>true])
            </div>
            <div class="clearfix"></div>
            <input type="hidden" id="category_id" name="category_id">


            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>

        </div>

    </form>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                category:{
                    url:'/admin/v1/skill/category',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                this.search(null, 'category');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'category.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.category.selected.length; i++) {
                        output.push(this.category.selected[i]['id']);
                    }
                    document.getElementById('category_id').value = JSON.stringify(output);
                },
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush
