@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.service.category.index')}}">لیست دسته بندی های خدمات</a></li>
                <li class="active">ایجاد دسته بندی</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.service.category.store')}}" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">لیست دسته بندی های خدمات</span>
                @include('share.extra.back2',['route'=>route('admin.service.category.index')])
            </div>

            <div class="col-md-12 mb20">
                <label for="departments">انتخاب دسته بندی ها</label>
                <multiselect id="departments" v-model="department.selected" :options="department.list" @search-change="search($event,'department')" :custom-label="customLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="department.list.length > 0 && isMoreResult('department')"  @click="moreResult('department')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="department.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'department_id'])
            </div>
            <div class="col-md-12">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر'])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-12">
                <label for="editor1">توضیحات</label>
                @include('share.forms.textarea',['name'=>'body','id'=>'editor1'])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'picture','title'=>'عکس'])
            </div>
            <div class="col-md-6 mt40">
                @include('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>true])
            </div>
            <div class="clearfix"></div>
            <div>
                <input type="hidden" id="department_id" name="department_id">
            </div>


            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>

        </div>

    </form>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>
    <script src="{{asset('assets/plugins/ck4/ckeditor.js')}}"></script>
    <script src="{{asset('assets/plugins/ck4/config.js')}}"></script>


    <script>
        $(document).ready(function () {
            $('select').material_select();

            var options = {
                filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
                filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=',
                filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
                filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token='
            };

            CKEDITOR.replace('editor1', options);
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                department:{
                    url:'/admin/v1/service/department',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                this.search(null, 'department');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'department.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.department.selected.length; i++) {
                        output.push(this.department.selected[i]['id']);
                    }
                    document.getElementById('department_id').value = JSON.stringify(output);
                },
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush
