@extends('admin.layout.master')
@section('content')
    <form method="post" action="{{route('admin.region.state.store')}}">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12 pd0 mb10">
                <ul class="custom-tab tabs blue-grey darken-2 z-depth-2">
                    <li class="tab"><a class="active" href="#state_tab">استان</a></li>
                    <li class="tab"><a @click.once="createMap" href="#tab_map">نقشه</a></li>
                </ul>
            </div>

            <div id="state_tab">
                <div class="col-md-6">
                    @include('share.forms.input',['name'=>'title','title'=>'تیتر'])
                </div>
                <div class="col-md-6 mb20">
                    <label for="countries">انتخاب کشور</label>
                    <multiselect id="countries" v-model="country.selected" :options="country.list" @search-change="search($event,'country')" :custom-label="customLabel" track-by="id" :internal-search="false">
                        <span v-if="country.list.length > 0 && isMoreResult('country')"  @click="moreResult('country')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="country.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>نتایج بیشتر</span>
                        </span>
                    </multiselect>
                    @include('share.forms.error',['name'=>'country_id'])
                </div>
                <div class="col-md-6">
                    @include('share.forms.input',['name'=>'order','title'=>'موقعیت','value'=>\App\Models\Region\state::count()+1])
                </div>
                <div class="col-md-6 mt40">
                    @include('share.forms.switch',['name'=>'status','title'=>'وضعیت','checked'=>true])
                </div>
            </div>
            <div id="tab_map">
                <div class="col-md-12">
                    <div class="input-field">
                        <input id="googlesearch" type="text" class="validate" v-model="map.address" @keyup="locateAddress">
                        <label for="googlesearch">جستجو</label>
                    </div>
                </div>
                <div id="map" class="col-md-12"></div>
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>
            <div>
                <input type="hidden" id="country_id" name="country_id">
                <input type="hidden" id="latitude"   name="latitude" value="35.6891975 51.388973599999986">
            </div>
        </div>
    </form>
    @include('share.extra.back',['route'=>route('admin.region.state.index')])
@endsection

@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCsRkWqKJAPPrqBZx-AsdvkPSCVHsRDqzw"></script>

    <script>
        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el: '#app',
            data: {
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                country:{
                    url:'/v1/region/country',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
                map:{
                    map:'',
                    marker:'',
                    address:'',
                    result:{
                        city:'Tehran',
                        lat:35.6891975,
                        lng:51.388973599999986
                    }
                }
            },
            created:function () {
                this.search(null,'country');
            },
            methods: {
                // Google Map
                createMap:function () {
                    this.map.map = new google.maps.Map(document.querySelector('#map'),{
                        center:{lat:this.map.result.lat,lng:this.map.result.lng},
                        zoom:10
                    });
                    this.map.marker = new google.maps.Marker({
                        map: this.map.map,
                        animation: google.maps.Animation.DROP,
                        position: {lat:this.map.result.lat,lng:this.map.result.lng}
                    });
                    this.map.marker.setAnimation(google.maps.Animation.BOUNCE);

                    google.maps.event.addListener(this.map.map, 'click', function (event) {
                        this.map.marker.setPosition(event.latLng);
                        this.map.result.lat = event.latLng.lat();
                        this.map.result.lng = event.latLng.lng();
                    }.bind(this));
                },
                locateAddress:function () {
                    var geocoder = new google.maps.Geocoder();
                    geocoder.geocode({address: this.map.address}, function (results,status) {
                        if (status === google.maps.GeocoderStatus.OK) {
                            this.map.map.setCenter(results[0].geometry.location);
                            this.map.result.city = results[0].address_components[0].long_name;
                            this.map.result.lat  = results[0].geometry.location.lat();
                            this.map.result.lng  = results[0].geometry.location.lng();
                            this.map.marker.setMap(null);
                            this.map.marker = new google.maps.Marker({
                                map: this.map.map,
                                animation: google.maps.Animation.DROP,
                                position: results[0].geometry.location
                            });
                            this.map.marker.setAnimation(google.maps.Animation.BOUNCE);
                        }
                        else {
                            console.log('noResult');
                        }
                    }.bind(this));
                },


                search: function (query,field,extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id+' - '+element.title;
                },
                isMoreResult:function (field) {
                    return (this[field].data.current_page+1 <= this[field].data.last_page);
                },
                moreResult:function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch: {
                'country.selected': function () {
                    if (this.country.selected) {
                        document.getElementById('country_id').value = this.country.selected.id;
                    }
                    else {
                        document.getElementById('country_id').value = null;
                    }
                },
                'map.result.lat':function () {
                    document.getElementById('latitude').value = this.map.result.lat+' '+this.map.result.lng;
                }
            }
        });
    </script>
@endpush

@push('styles')
    <style>
        #map {
            width: 100%;
            height: 500px;
        }
    </style>
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush
