@extends('admin.layout.master')

@section('content')
    <form method="post" action="{{route('admin.region.country.update',$country->id)}}">
        {{ csrf_field() }}
        {{ method_field('PUT') }}
        <div class="row white z-depth-1">
            <div class="col-md-12 pd0 mb10">
                <ul class="custom-tab tabs blue-grey darken-2 z-depth-2">
                    <li class="tab"><a class="active" href="#country_tab">کشور</a></li>
                    <li class="tab"><a @click.once="createMap" href="#tab_map">نقشه</a></li>
                </ul>
            </div>

            <div id="country_tab">
                <div class="col-md-6">
                    @include('share.forms.input',['name'=>'title','title'=>'تیتر','value'=>$country->title])
                </div>
                <div class="col-md-6">
                    @include('share.forms.input',['name'=>'code','title'=>'کد','value'=>$country->code])
                </div>
                <div class="clearfix"></div>
                <div class="col-md-6">
                    @include('share.forms.input',['name'=>'order','title'=>'موقعیت','value'=>$country->order])
                </div>
                <div class="col-md-6 mt40">
                    @include('share.forms.switch',['name'=>'status','title'=>'وضعیت','checked'=>$country->status])
                </div>
            </div>
            <div id="tab_map">
                <div class="col-md-12">
                    <div class="input-field">
                        <input id="googlesearch" type="text" class="validate" v-model="map.address" @keyup="locateAddress">
                        <label for="googlesearch">جستجو</label>
                    </div>
                </div>
                <div id="map" class="col-md-12"></div>
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>
            <div>
                <input type="hidden" id="latitude" name="latitude" value="{{$country->latitude}}">
            </div>
        </div>
    </form>
    @include('share.extra.back',['route'=>route('admin.region.country.index')])
@endsection


@push('scripts')
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCsRkWqKJAPPrqBZx-AsdvkPSCVHsRDqzw"></script>

    <script>
        new Vue({
            el:'#app',
            data:{
                ax: axios.create({baseURL: baseUrl, headers: {'Authorization': 'Bearer {{auth()->user()->api_token}}'}}),

                map:{
                    map:'',
                    marker:'',
                    address:'',
                    result:{
                        city:'Tehran',
                        lat:35.6891975,
                        lng:51.388973599999986
                    }
                }
            },
            created: function () {
                var lat = document.getElementById('latitude').value;
                if (lat) {
                    lat = lat.split(' ');
                    this.map.result.lat = parseFloat(lat[0]);
                    this.map.result.lng = parseFloat(lat[1]);
                }
            },
            methods:{
                // Google Map
                createMap: function () {
                    this.map.map = new google.maps.Map(document.querySelector('#map'), {
                        center: {lat: this.map.result.lat, lng: this.map.result.lng},
                        zoom: 10
                    });
                    this.map.marker = new google.maps.Marker({
                        map: this.map.map,
                        animation: google.maps.Animation.DROP,
                        position: {lat: this.map.result.lat, lng: this.map.result.lng}
                    });
                    this.map.marker.setAnimation(google.maps.Animation.BOUNCE);

                    google.maps.event.addListener(this.map.map, 'click', function (event) {
                        this.map.marker.setPosition(event.latLng);
                        this.map.result.lat = event.latLng.lat();
                        this.map.result.lng = event.latLng.lng();
                    }.bind(this));
                },
                locateAddress: function () {
                    var geocoder = new google.maps.Geocoder();
                    geocoder.geocode({address: this.map.address}, function (results, status) {
                        if (status === google.maps.GeocoderStatus.OK) {
                            this.map.map.setCenter(results[0].geometry.location);
                            this.map.result.city = results[0].address_components[0].long_name;
                            this.map.result.lat = results[0].geometry.location.lat();
                            this.map.result.lng = results[0].geometry.location.lng();
                            this.map.marker.setMap(null);
                            this.map.marker = new google.maps.Marker({
                                map: this.map.map,
                                animation: google.maps.Animation.DROP,
                                position: results[0].geometry.location
                            });
                            this.map.marker.setAnimation(google.maps.Animation.BOUNCE);
                        }
                        else {
                            console.log('noResult');
                        }
                    }.bind(this));
                },
            },
            watch:{
                'map.result.lat':function () {
                    document.getElementById('latitude').value = this.map.result.lat+' '+this.map.result.lng;
                }
            }
        });
    </script>
@endpush

@push('styles')
    <style>
        #map {
            width: 100%;
            height: 500px;
        }
    </style>
@endpush
