@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">داشبورد</a></li>
                <li><a href="{{route('admin.academy.academytype.index')}}">لیست نوع آموزشگاه</a></li>
                <li class="active">ایجاد نوع آموزشگاه</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.academy.academytype.store')}}" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد نوع آموزشگاه</span>
                @include('share.extra.back2',['route'=>route('admin.academy.academytype.index')])
            </div>

            <div class="col-md-12 mt15">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر'])
            </div>
            <div class="col-md-12">
                @include('share.forms.textarea-Material',['name'=>'body','title'=>'توضیحات'])
            </div>
            <div class="col-md-6 mt40">
                @include('share.forms.switch',['name'=>'status','title'=>'وضعیت','checked' => 1])
            </div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'picture','title'=>'عکس'])
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>

        </div>

    </form>
@endsection
