@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.academy.academy.index')}}">لیست نمایندگی ها</a></li>
                <li class="active">ویرایش نماینده ها</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.academy.academy.update',$academy->id)}}" enctype="multipart/form-data">
        {{ method_field('PUT') }}
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش نماینده</span>
                @include('share.extra.back2',['route'=>route('admin.academy.academy.index')])
            </div>

            <div class="col-md-6 mb20">
                <label for="users">انتخاب کاربر</label>
                <multiselect id="users" v-model="user.selected" :options="user.list" @search-change="search($event,'user')" :custom-label="userLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="user.list.length > 0 && isMoreResult('user')"  @click="moreResult('user')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="user.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'user_id'])
            </div>
            <div class="col-md-6 mb20">
                <label for="areas">انتخاب منطقه</label>
                <multiselect id="areas" v-model="area.selected" :options="area.list" @search-change="search($event,'area')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="area.list.length > 0 && isMoreResult('area')"  @click="moreResult('area')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="area.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'area_id'])
            </div>

            <div class="col-md-12 mt15">
                @include('share.forms.input',['name'=>'title','title'=>'نام نمایندگی','value'=>$academy->title])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-4">
                @include('share.forms.input',['name'=>'telephone','class'=>'dleft','title'=>'تلفن','value'=>$academy->telephone])
            </div>
            <div class="col-md-4">
                @include('share.forms.input',['name'=>'fax','class'=>'dleft','title'=>'فکس','value'=>$academy->fax])
            </div>
            <div class="col-md-4">
                @include('share.forms.input',['name'=>'postalCode','class'=>'dleft','title'=>'کد پستی','value'=>$academy->postalCode])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'website','class'=>'dleft','title'=>'وب سایت','value'=>$academy->website])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'email','class'=>'dleft','title'=>'ایمیل','value'=>$academy->email])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-12">
                @include('share.forms.input',['name'=>'address','class'=>'dleft','title'=>'آدرس','value'=>$academy->address])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'telegram','class'=>'dleft','title'=>'تلگرام','value'=>$academy->telegram])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'whatsapp','class'=>'dleft','title'=>'واتس آپ','value'=>$academy->whatsapp])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'referalCode','class'=>'dleft','title'=>'کد معرف','value'=>$academy->referalCode])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6 mt40">
                @include('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>$academy->status])
            </div>
            <div class="col-md-6 mt40">
                @include('share.forms.switch',['name'=>'payStatus','title'=>'وضعیت پرداخت','checked'=>$academy->payStatus])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-4">
                @include('share.forms.file',['name'=>'cereficate','title'=>'مدرک'])
                @if($academy->cereficate)
                    <img src="{{asset($academy->cereficate)}}" class="img-responsive img-raised hg200 text-center" alt="">
                @endif
            </div>
            <div class="col-md-4">
                @include('share.forms.file',['name'=>'logo','title'=>'لوگو'])
                @if($academy->logo)
                    <img src="{{asset($academy->logo)}}" class="img-responsive img-raised hg200 text-center" alt="">
                @endif
            </div>
            <div class="col-md-4">
                @include('share.forms.file',['name'=>'picture','title'=>'عکس'])
                @if($academy->logo)
                    <img src="{{asset($academy->logo)}}" class="img-responsive img-raised hg200 text-center" alt="">
                @endif
            </div>

            <div class="clearfix"></div>
            <hr class="mt40">
            <h5 class="pd4 br4 blue-grey darken-2 text-center white-text half center-block">مشخصات موسس</h5>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'firstNameOwner','title'=>'نام موسس','value'=>$academy->firstNameOwner])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'lastNameOwner','title'=>'نام خانوادگی موسس','value'=>$academy->lastNameOwner])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'birthdayOwner','title'=>'تاریخ تولد موسس','class' => 'birthday', 'id'=> 'birthdayOwner'])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'birthplaceOwner','title'=>'محل تولد موسس'])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-4">
                @include('share.forms.input',['name'=>'mobileOwner','title'=>'موبایل موسس','class' => 'dleft','value'=>$academy->mobileOwner])
            </div>
            <div class="col-md-4">
                @include('share.forms.input',['name'=>'nationalCodeOwner','title'=>'کد ملی موسس','class' => 'dleft','value'=>$academy->nationalCodeOwner])
            </div>
            <div class="col-md-4">
                @include('share.forms.file',['name'=>'nationalCardOwner','title'=>'کارت ملی موسس'])
                @if($academy->nationalCardOwner)
                    <img src="{{asset($academy->nationalCardOwner)}}" class="img-responsive img-raised hg200 text-center" alt="">
                @endif
            </div>
            <div class="clearfix"></div>
            <hr class="mt40">
            <h5 class="pd4 br4 blue-grey darken-2 text-center white-text half center-block">مشخصات مدیر آموزشگاه</h5>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'firstNameAdmin','title'=>'نام مدیر','value'=>$academy->firstNameAdmin])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'lastNameAdmin','title'=>'نام خانوادگی مدیر','value'=>$academy->lastNameAdmin])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'birthdayAdmin','title'=>'تاریخ تولد مدیر','class' => 'birthday','id'=> 'birthdayAdmin'])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'birthplaceAdmin','title'=>'محل تولد مدیر','value'=>$academy->birthplaceAdmin])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-4">
                @include('share.forms.input',['name'=>'mobileAdmin','title'=>'موبایل مدیر','class' => 'dleft','value'=>$academy->mobileAdmin])
            </div>
            <div class="col-md-4">
                @include('share.forms.input',['name'=>'nationalCodeAdmin','title'=>'کد ملی مدیر','class' => 'dleft','value'=>$academy->nationalCodeAdmin])
            </div>
            <div class="col-md-4">
                @include('share.forms.file',['name'=>'nationalCardAdmin','title'=>'کارت ملی مدیر'])
                @if($academy->nationalCardAdmin)
                    <img src="{{asset($academy->nationalCardAdmin)}}" class="img-responsive img-raised hg200 text-center" alt="">
                @endif
            </div>

            <div>
                <input type="hidden" id="user_id" name="user_id" value="{{$academy->user_id}}">
                <input type="hidden" id="area_id" name="area_id" value="{{$academy->area_id}}">
            </div>


            <div class="col-md-12 mb20 mt20">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>

        </div>
    </form>
@endsection

@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>
    <script src="{{asset('assets/plugins/datePicker/persianDate.js')}}"></script>
    <script src="{{asset('assets/plugins/datePicker/datePicker.js')}}"></script>

    <script>
        $(document).ready(function () {
            $(".birthday").pDatepicker({
                format: "YYYY/MM/DD",
                maxDate: new persianDate().valueOf(),
                initialValueType: 'gregorian'
            });
            $('#birthdayOwner').val('{{toPersian($academy->birthdayOwner)}}');
            $('#birthdayAdmin').val('{{toPersian($academy->birthdayAdmin)}}');
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                user:{
                    url:'/v1/admin/users/user',
                    list:[@json($academy->user)],
                    selected:[@json($academy->user)],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
                area:{
                    url:'/v1/region/area',
                    list:[@json($academy->area)],
                    selected:[@json($academy->area)],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                if (this.user.selected.length == 0) {
                    this.search(null, 'user');
                }
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                userLabel: function (element) {
                    return element.id + ' - ' + element.firstName +' - ' + element.lastName;
                },

                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'user.selected': function () {
                    if (this.user.selected.id) {
                        document.getElementById('user_id').value = this.user.selected.id;
                    } else {
                        document.getElementById('user_id').value = null;
                    }
                },
                'area.selected': function () {
                    if (this.area.selected.id) {
                        document.getElementById('area_id').value = this.area.selected.id;
                    } else {
                        document.getElementById('area_id').value = null;
                    }
                },
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/persianDatePicker.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/custom.css')}}" />
@endpush
