<?php

use App\Models\Setting\setting;
use App\Models\Setting\settingAdmin;
use App\Models\Setting\settingCategoryAdmin;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class settingSeeder extends Seeder
{

    public function run()
    {
        $this->settingUser();
    }

    private function settingAdminCat()
    {
        if (settingCategoryAdmin::count() === 0) {
            $carbon = new Carbon();
            settingCategoryAdmin::insert([
                ['id'=>1,'title'=>'Main','type'=>'default','created_at'=>$carbon->now(),'updated_at'=>$carbon->now()],
                ['id'=>2,'title'=>'Telegram','type'=>'default','created_at'=>$carbon->now(),'updated_at'=>$carbon->now()],
            ]);
        }
    }

    private function settingAdmin()
    {
        $this->settingAdminCat();
        if (settingAdmin::count() === 0) {
            $carbon = new Carbon();
            settingAdmin::insert([

                ['category_id' => 1, 'title' => 'Logo', 'name' => 'site_logo', 'type' => 'file', 'linkable' => 0, 'created_at' => $carbon->now(), 'updated_at' => $carbon->now()],
                ['category_id' => 1, 'title' => 'Address', 'name' => 'site_address', 'type' => 'string', 'linkable' => 0, 'created_at' => $carbon->now(), 'updated_at' => $carbon->now()],
                ['category_id' => 1, 'title' => 'Telephone', 'name' => 'site_telephone', 'type' => 'string', 'linkable' => 0, 'created_at' => $carbon->now(), 'updated_at' => $carbon->now()],
                ['category_id' => 1, 'title' => 'Email', 'name' => 'site_email', 'type' => 'string', 'linkable' => 0, 'created_at' => $carbon->now(), 'updated_at' => $carbon->now()],
                ['category_id' => 1, 'title' => 'Site Name (print)', 'name' => 'site_name', 'type' => 'string', 'linkable' => 0, 'created_at' => $carbon->now(), 'updated_at' => $carbon->now()],

                ['category_id' => 2, 'title' => 'Telegram ID', 'name' => 'telegram_profiles', 'type' => 'string', 'linkable' => 0, 'created_at' => $carbon->now(), 'updated_at' => $carbon->now()],
                ['category_id' => 2, 'title' => 'Robot ID', 'name' => 'telegram_robotid', 'type' => 'string', 'linkable' => 0, 'created_at' => $carbon->now(), 'updated_at' => $carbon->now()],

            ]);
        }
    }

    private function settingUser()
    {

        $this->settingAdmin();
        if (setting::count() === 0) {
            foreach (settingAdmin::all() as $item) {
                $item->settings()->create([
                    'value' => null,
                    'link'  => null
                ]);
            }
            setting::cache();
        }
    }

}
