<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWalletRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wallet_requests', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('wallet_id')->index();
            $table->foreign('wallet_id')->references('id')->on('wallets')->onDelete('cascade');

            $table->double('amount')->default(0);
            $table->string('body',4096)->nullable();
            $table->string('status',32)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wallet_requests');
    }
}
