<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserAddressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_addresses', function (Blueprint $table) {
            $table->increments('id')->index();

            $table->unsignedBigInteger('user_id')->index();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->integer('city_id')->nullable()->index();
            $table->string('email',512)->nullable();
            $table->string('firstName')->nullable();
            $table->string('lastName')->nullable();
            $table->enum('gender',['male','female'])->default('male');
            $table->string('mobile',16)->nullable();
            $table->string('telephone',16)->nullable();
            $table->string('postalCode',16)->nullable();
            $table->string('nationalCode',16)->nullable();
            $table->string('address',1024)->nullable();
            $table->string('body',4096)->nullable();
            $table->string('pathcard',128)->nullable();
            $table->string('pathpic',128)->nullable();
            $table->double('lat')->nullable();
            $table->double('lng')->nullable();
            $table->dateTime('mobile_verify_at')->nullable();
            $table->string('mobile_verify_code',16)->nullable();
            $table->boolean('mobileValidate')->default(0);
            $table->boolean('telephoneValidate')->default(0);
            $table->boolean('canEdit')->default(0);
            $table->boolean('status')->nullable();

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_addresses');
    }
}
