<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->integer('city_id')->nullable();

            $table->string('userName')->unique()->index();
            $table->string('email')->nullable()->index();
            $table->string('firstName')->nullable()->index();
            $table->string('lastName')->nullable()->index();
            $table->string('fatherName')->nullable()->index();
            $table->enum('gender',['male','female'])->default('male');
            $table->string('nationalCode',32)->nullable();
            $table->string('certificateCode',32)->nullable();
            $table->string('postalCode',32)->nullable();
            $table->date('birthday')->nullable();
            $table->string('birthplace')->nullable();
            $table->string('mobile',32)->nullable()->index();
            $table->string('telephone',32)->nullable()->index();
            $table->string('address',2048)->nullable();
            $table->string('education')->nullable();
            $table->string('job')->nullable();
            $table->string('fieldOfStudy')->nullable();
            $table->boolean('saveSkill')->nullable();

            $table->string('api_token',256)->nullable();
            $table->boolean('canEdit')->default(0);
            $table->boolean('isActive')->default(0);
            $table->boolean('isPay')->default(0);
            $table->boolean('isAdmin')->default(0);
            $table->string('type',32)->nullable();
            $table->string('ref',128)->unique()->index();

            $table->string('educationPicture')->nullable();
            $table->string('personalPicture')->nullable();
            $table->string('nationalCardPicture')->nullable();


            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('mobile_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
