<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTicketFilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ticket_files', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('ticketMessage_id');
            $table->foreign('ticketMessage_id')->references('id')->on('ticket_messages')->onDelete('cascade');

            $table->string('path',128);
            $table->string('mime',32);
            $table->integer('size');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ticket_files');
    }
}
