<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTicketsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->unsignedBigInteger('ticketDepartment_id');
            $table->foreign('ticketDepartment_id')->references('id')->on('ticket_departments')->onDelete('cascade');

            $table->string('title',512)->index();
            $table->text('body')->nullable();
            $table->string('pathFile',128)->nullable();
            $table->boolean('isRead')->default(0);
            $table->enum('priority',['urgent','high','medium','low'])->default('medium');
            $table->enum('status',['open','pending','closed','deactive'])->default('open');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tickets');
    }
}
