<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSettingAdminsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('setting_admins', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('category_id');
            $table->foreign('category_id')->references('id')->on('setting_category_admins')->onDelete('cascade');

            $table->string('title')->nullable();
            $table->string('name')->nullable();
            $table->string('class')->nullable();
            $table->integer('column')->default(12);
            $table->string('value')->nullable();
            $table->boolean('linkable')->default(0);
            $table->string('type',32)->default('string');
            $table->boolean('status')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('setting_admins');
    }
}
