<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServiceCardStatusesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('service_card_statuses', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('service_card_id')->index();
            $table->foreign('service_card_id')->references('id')->on('service_cards')->onDelete('cascade');

            $table->string('title')->nullable();
            $table->boolean('status')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('service_card_statuses');
    }
}
