<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServiceDepartmentSerivceCategoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('serviceDepartment_serviceCategory', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('service_department_id')->index();
            $table->foreign('service_department_id')->references('id')->on('service_departments')->onDelete('cascade');

            $table->unsignedBigInteger('service_category_id')->index();
            $table->foreign('service_category_id')->references('id')->on('service_categories')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('serviceDepartment_serviceCategory');
    }
}
