<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBankAccountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_accounts', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->string('title',512);
            $table->string('type',32)->nullable();
            $table->string('accountName',512)->nullable();
            $table->string('accountNumber',32)->nullable();
            $table->string('cardNumber',32)->nullable();
            $table->string('shaba',512);
            $table->double('amount')->default(0);
            $table->boolean('status')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank_accounts');
    }
}
