<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('order_id');
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');

            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->integer('gateway_id')->index();
            $table->string('gatewayType',32)->index();
            $table->string('pin',128)->index();
            $table->string('body',4096)->nullable();
            $table->string('device')->nullable();
            $table->string('ip',32)->nullable();
            $table->string('browser',32)->nullable();
            $table->string('browserVersion',32)->nullable();
            $table->string('os',32)->nullable();
            $table->string('osVersion',32)->nullable();
            $table->string('refNumber',32)->nullable();
            $table->double('price')->default(0);
            $table->string('statusGateway',32)->nullable();
            $table->string('status',32)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
