<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGatewaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gateways', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->string('title',512)->index();
            $table->string('name',256)->index();
            $table->string('type',32)->index();
            $table->integer('order')->default(0)->index();
            $table->string('body',4096)->nullable();
            $table->string('picture')->nullable();
            $table->boolean('status')->defualt(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gateways');
    }
}
