<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_items', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('order_id');
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');

            $table->string('model_type', 64)->index();
            $table->integer('model_id')->index();

            $table->string('title', 2048)->nullable();
            $table->float('weight')->default(0);
            $table->integer('qty')->default(0);
            $table->double('unitPrice')->default(0);
            $table->double('finalPrice')->default(0);

            $table->string('systemDescription', 4096)->nullable();
            $table->string('adminDescription', 4096)->nullable();

            $table->double('discount')->default(0)->index();
            $table->string('discountCode', 32)->default(0)->index();
            $table->string('discountDescription')->nullable()->index();

            $table->double('sendCost')->default(0);
            $table->string('sendCode')->nullable();
            $table->string('sendType', 16)->nullable();
            $table->string('sendStatus', 16)->nullable();

            $table->string('type', 16)->nullable();
            $table->string('status', 16)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_items');
    }
}
