<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAcademiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academies', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('user_id')->index();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->unsignedBigInteger('area_id')->index();
            $table->foreign('area_id')->references('id')->on('areas')->onDelete('cascade');

            $table->string('type_id')->nullable();
            $table->string('agent_id')->nullable();

            $table->string('firstNameOwner',512)->nullable();
            $table->string('lastNameOwner',512)->nullable();
            $table->string('nationalCodeOwner',32)->nullable();
            $table->date('birthdayOwner')->nullable();
            $table->string('birthplaceOwner')->nullable();
            $table->string('mobileOwner',16)->nullable();
            $table->string('nationalCardOwner')->nullable();
            $table->string('firstNameAdmin',512)->nullable();
            $table->string('lastNameAdmin',512)->nullable();
            $table->string('nationalCodeAdmin',32)->nullable();
            $table->date('birthdayAdmin')->nullable();
            $table->string('birthplaceAdmin')->nullable();
            $table->string('mobileAdmin',16)->nullable();
            $table->string('nationalCardAdmin')->nullable();
            $table->string('title',1024)->nullable()->index();
            $table->string('email',512)->nullable();
            $table->string('fax',32)->nullable();
            $table->string('website',512)->nullable();
            $table->string('telephone',16)->nullable();
            $table->string('address',2048)->nullable();
            $table->string('postalCode',32)->nullable();
            $table->string('telegram')->nullable();
            $table->string('whatsapp',32)->nullable();
            $table->string('cereficate')->nullable();
            $table->string('body',4096)->nullable();
            $table->string('referalCode',32)->nullable();
            $table->string('picture')->nullable();
            $table->string('logo')->nullable();
            $table->double('payPrice')->default(0);
            $table->boolean('payStatus')->nullable();
            $table->boolean('status')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('academies');
    }
}
