<?php

namespace App\Models\Wallet;

use Illuminate\Database\Eloquent\Model;

class walletTransaction extends Model
{
    protected $fillable = [
        'wallet_id',
        'type',
        'amount',
        'body',
        'editedBy',
        'status'
    ];
    protected $appends = ['statusTranslate'];


    // Relations

    public function wallet()
    {
        return $this->belongsTo(Wallet::class);
    }


    // Attribute

    public function getStatusTranslateAttribute()
    {
        if ($this->status == 'pending') {
            return 'در حال بررسی';
        } elseif ($this->status == 'success') {
            return 'تایید شده';
        } else {
            return 'رد شده';
        }
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);
        foreach ($request->all() as $key => $value) {
            if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                $query->orderBy($keyResult, $value);
            }
        }

        $query->where(function ($query) use ($request,$fillables) {
            foreach ($request->all() as $key => $value) {
                if (array_search($key, $fillables) !== false) {
                    if ($key != 'api_token') {
                        $query->where($key, $value);
                    }
                } elseif (str_contains($key,'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->where($keyResult, 'like', "%{$value}%");
                }
            }

            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('wallet_id', 'like', "%{$request->input('query')}%");
                $query->orWhere('amount', 'like', "%{$request->input('query')}%");
            }


            if ($request->has('date_start')) {
                $query->whereDate('created_at', '>=', "{$request->input('start')}");
            }

            if ($request->has('date_end')) {
                $query->whereDate('created_at', '<=', "{$request->input('end')}");
            }

        });

        return $query;
    }

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->user()->id);
    }

}
