<?php

namespace App\Models\Ticket;

use App\User;
use Illuminate\Database\Eloquent\Model;

class ticketMessage extends Model
{

    public $fillable = [
        'ticket_id',
        'user_id',
        'body',
        'type',
        'status',
    ];


    // Relations

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function ticket()
    {
        return $this->belongsTo(ticket::class);
    }

    public function files()
    {
        return $this->hasMany(ticketFile::class,'ticketMessage_id');
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $result  = $request->only(array_merge($this->getFillable(),['id']));
        foreach ($result as $key => $value) {
            $query->orderBy($key,$value);
        }

        if ($request->has('query')) {
            $query->orWhere('id','like', "%{$request->input('query')}%");
            $query->orWhere('amount','like',"%{$request->input('query')}%");
        }
        return $query;
    }

    public function scopeValidate($query)
    {
        return $query->where('status', 1);
    }

}
