<?php

namespace App\Models\Setting;

use App\User;
use Illuminate\Database\Eloquent\Model;

class settingUser extends Model
{
    protected $fillable = [
        'settingAdmin_id',
        'user_id',
        'value',
        'link'
    ];


    // Relations

    public function category()
    {
        return $this->belongsTo(settingAdmin::class,'settingAdmin_id');
    }

    public function user()
    {
        return $this->belongsToMany(User::class);
    }


    // Scopes

    public function scopeCache()
    {
       $list = $this->join('setting_admins','setting_users.settingAdmin_id','=','setting_admins.id')
            ->select('setting_users.id','setting_users.value','setting_users.link','setting_admins.title','setting_admins.name','setting_admins.type','setting_users.created_at','setting_users.updated_at')
            ->get();
        cache()->forever('setting_users',$list);

        return cache('setting_users');
    }

    public function scopeSearch($query,$request)
    {
        $result  = $request->intersect(array_merge($this->getFillable(),['id']));
        foreach ($result as $key => $value) {
            $query->orderBy($key,$value);
        }

        if ($request->has('query')) {
            $query->orWhere('id','like', "%{$request->input('query')}%");
            $query->orWhere('value','like',"%{$request->input('query')}%");
            $query->orWhere('settingAdmin_id','like',"%{$request->input('query')}%");
        }

        return $query;
    }
}
