<?php

namespace App\Models\Setting;

use function foo\func;
use Illuminate\Database\Eloquent\Model;

class settingAdmin extends Model
{
    protected $fillable = [
        'category_id',
        'title',
        'name',
        'class',
        'column',
        'value',
        'type',
        'linkable',
        'status'
    ];


    // Relations

    public function category()
    {
        return $this->belongsTo(settingCategoryAdmin::class,'category_id');
    }

    public function settings()
    {
        return $this->hasOne(setting::class,'settingAdmin_id');
    }

    public function settingUser()
    {
        return $this->hasOne(settingUser::class,'settingAdmin_id');
    }

    public function settingMain()
    {
        return $this->hasOne(settingMain::class,'settingAdmin_id');
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id','settings_admin_count']);

        $query->where(function ($query) use ($request, $fillables) {

            foreach ($request->all() as $key => $value) {
                if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                    $query->orderBy($keyResult, $value);
                } elseif (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->orWhere($keyResult, 'like', "%{$value}%");
                }
            }


            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
                $query->orWhere('type', 'like', "%{$request->input('query')}%");
            }

        });


        return $query;
    }
}
