<?php

namespace App\Models\Setting;

use Illuminate\Database\Eloquent\Model;

class setting extends Model
{
    protected $fillable = [
        'settingAdmin_id',
        'value',
        'link'
    ];

    public function category()
    {
        return $this->belongsTo(settingAdmin::class,'settingCat_id');
    }

    public function scopeCache($query, $type = 'default')
    {
        $list = $this->join('setting_admins', 'settings.settingAdmin_id', '=', 'setting_admins.id')
            ->join('setting_category_admins', 'setting_admins.category_id', '=', 'setting_category_admins.id')->where('setting_category_admins.type',$type)
            ->select('settings.id', 'settings.value', 'settings.link', 'setting_admins.title', 'setting_admins.name', 'setting_admins.type')
            ->get();
        cache()->forever("settings_$type",$list);

        return cache("settings_$type");
    }

    public function scopeSearch($query,$request)
    {
        $result  = $request->intersect(array_merge($this->getFillable(),['id']));
        foreach ($result as $key => $value) {
            $query->orderBy($key,$value);
        }

        if ($request->has('query')) {
            $query->orWhere('id','like', "%{$request->input('query')}%");
            $query->orWhere('value','like',"%{$request->input('query')}%");
            $query->orWhere('settingCat_id','like',"%{$request->input('query')}%");
        }
        return $query;
    }
}
