<?php

namespace App\Models\Service;

use App\User;
use Illuminate\Database\Eloquent\Model;

class serviceCardStatus extends Model
{
    protected $fillable = [
        'service_card_id',
        'title',
        'status'
    ];


    // Relations

    public function serviceCard()
    {
        return $this->belongsTo(serviceCard::class);
    }

    public function user()
    {
        return $this->belongsToMany(User::class, 'serviceCardStatus_user');
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);
        foreach ($request->all() as $key => $value) {
            if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                $query->orderBy($keyResult, $value);
            }
        }

        $query->where(function ($query) use ($request,$fillables) {
            foreach ($request->all() as $key => $value) {
                if (array_search($key, $fillables) !== false) {
                    if ($key != 'api_token') {
                        $query->where($key, $value);
                    }
                } elseif (str_contains($key,'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->where($keyResult, 'like', "%{$value}%");
                }
            }

            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
            }

            if ($request->has('date_start')) {
                $query->whereDate('created_at', '>=', "{$request->input('start')}");
            }

            if ($request->has('date_end')) {
                $query->whereDate('created_at', '<=', "{$request->input('end')}");
            }

        });

        return $query;
    }


    public function scopeValidate($query)
    {
        return $query->where('status',1);
    }
}
