<?php

namespace App\Models\Region;

use Illuminate\Database\Eloquent\Model;

class country extends Model
{
    protected $fillable = [
        'title',
        'code',
        'latitude',
        'order',
        'status'
    ];


    // Relations

    public function states()
    {
        return $this->hasMany(state::class);
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id', 'cities_count']);
        $query->where(function ($query) use ($request, $fillables) {

            foreach ($request->all() as $key => $value) {
                if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                    $query->orderBy($keyResult, $value);
                } elseif (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->orWhere($keyResult, 'like', "%{$value}%");
                }
            }


            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
                $query->orWhere('code', 'like', "%{$request->input('query')}%");
            }

        });



        if ($request->has('state_title') || $request->has('state_id')) {
            $query->whereHas('state', function ($query) use ($request) {
                if ($request->has('state_title')) {
                    $query->where('states.title', $request()->input('state_title'));
                }

                if (is_array($request->input('state_id', false))) {
                    $query->whereIn('states.id', $request()->input('state_id'));
                }
            });
        }

        if ($request->input('withstate',0) == 1) {
            $query->with('states');
        }

        return $query;
    }

    public function scopeValidate($query)
    {
        return $query->where('status', 1);
    }
}
