<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\Model;

class orderItem extends Model
{
    protected $fillable = [
        'order_id',
        'model_type',
        'model_id',
        'title',
        'weight',
        'qty',
        'unitPrice',
        'finalPrice',
        'systemDescription',
        'adminDescription',
        'discount',
        'discountCode',
        'discountDescription',
        'sendCost',
        'sendCode',
        'sendType',
        'sendStatus',
        'type',
        'status'
    ];
    protected $appends = ['statusTranslate','currencyTranslate','statusPayTranslate','payTypeTranslate','currencyTranslate'];


    // Relations

    public function order()
    {
        return $this->belongsTo(order::class);
    }

    public function orderLabel()
    {
        return $this->belongsToMany(orderLabel::class,'orderLabel_orderItem');
    }

    public function model()
    {
        return $this->morphTo();
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);

        $query->where(function ($query) use ($request, $fillables) {

            foreach ($request->all() as $key => $value) {
                if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                    $query->orderBy($keyResult, $value);
                } elseif (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->orWhere($keyResult, 'like', "%{$value}%");
                }
            }


            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
            }

        });

        return $query;
    }

    public function scopeOwn($query)
    {
        $query->whereHas('order', function ($order) {
            $order->where('user_id', auth()->user()->id);
        });

        return $query;
    }

    // Extra Methods

    public function getStatusTranslateAttribute()
    {
        if ($this->status == 'success') {
            return trans('Financial::general.labels.unkown');
        } elseif ($this->status == null) {
            return trans('Financial::general.labels.successDelivery');
        } elseif ($this->status == 'error') {
            return trans('Financial::general.labels.errorDelivery');
        } elseif ($this->status == 'pending') {
            return trans('Financial::general.labels.pending');
        }

        return $this->status;
    }

    public function getStatusPayTranslateAttribute()
    {
        if ($this->statusPay == 'success') {
            return trans('Financial::general.labels.success');
        } elseif ($this->statusPay == 'pending') {
            return trans('Financial::general.labels.pending');
        } elseif ($this->statusPay == 'unsuccess') {
            return trans('Financial::general.labels.unsuccess');
        } elseif ($this->statusPay == null) {
            return trans('Financial::general.labels.unpay');
        }

        return $this->statusPay;
    }

    public function getPayTypeTranslateAttribute()
    {
        if ($this->payType == 'gateway') {
            return trans('Financial::general.labels.gateway');
        } elseif ($this->payType == null) {
            return trans('Financial::general.labels.unkown');
        } elseif ($this->payType == 'crypto') {
            return trans('Financial::general.labels.crypto');
        }

        return $this->payType;
    }

    public function getCurrencyTranslateAttribute()
    {
        if ($this->currency == 'toman') {
            return trans('Financial::general.labels.toman');
        } elseif ($this->currency == null) {
            return trans('Financial::general.labels.unkown');
        }

        return $this->currency;
    }

}
