<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\Model;

class orderDate extends Model
{
    protected $fillable = [
        'day',
        'start',
        'end',
        'status'
    ];


    // Relations

    public function order()
    {
        return $this->hasMany(order::class);
    }



    // Scoeps

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);

        foreach ($request->all() as $key => $value) {
            if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                $query->orderBy($keyResult, $value);
            } elseif (array_search($key, $fillables) !== false) {
                $query->where($key, $value);
            } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                $query->orWhere($keyResult, 'like', "%{$value}%");
            }
        }

        $query->where(function ($query) use ($request) {

            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
            }

        });

        return $query;
    }

    public function scopeValidate($query)
    {
        return $query->where('status',1);
    }
}
