<?php

namespace App\Models\Academy;

use App\academyType;
use App\Models\Region\area;
use App\User;
use Illuminate\Database\Eloquent\Model;

class academy extends Model
{
    protected $fillable = [
        'user_id',
        'area_id',
        'firstNameOwner',
        'lastNameOwner',
        'nationalCodeOwner',
        'birthdayOwner',
        'birthplaceOwner',
        'mobileOwner',
        'nationalCardOwner',
        'firstNameAdmin',
        'lastNameAdmin',
        'nationalCodeAdmin',
        'birthdayAdmin',
        'birthplaceAdmin',
        'mobileAdmin',
        'nationalCardAdmin',
        'title',
        'email',
        'fax',
        'website',
        'telephone',
        'address',
        'postalCode',
        'telegram',
        'whatsapp',
        'cereficate',
        'type',
        'referalCode',
        'logo',
        'picture',
        'payPrice',
        'payStatus',
        'status'
    ];


    // Relations

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function area()
    {
        return $this->belongsTo(area::class);
    }

    public function agent()
    {
        return $this->belongsTo(agent::class);
    }

    public function type()
    {
        return $this->belongsTo(academyType::class);
    }

    public function student()
    {
        return $this->hasMany(student::class);
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);
        foreach ($request->all() as $key => $value) {
            if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                $query->orderBy($keyResult, $value);
            }
        }

        $query->where(function ($query) use ($request,$fillables) {
            foreach ($request->all() as $key => $value) {
                if (array_search($key, $fillables) !== false) {
                    if ($key != 'api_token') {
                        $query->where($key, $value);
                    }
                } elseif (str_contains($key,'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->where($keyResult, 'like', "%{$value}%");
                }
            }

            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
            }

            if ($request->has('date_start')) {
                $query->whereDate('created_at', '>=', "{$request->input('start')}");
            }

            if ($request->has('date_end')) {
                $query->whereDate('created_at', '<=', "{$request->input('end')}");
            }

        });

        return $query;
    }

    public function scopeValidate($query)
    {
        return $query->where('status',1);
    }
}
