<?php


function getDefaultPhoto(){
    return 'files/default.jpg';
}

function toPersian($timestamp,$format='Y/m/d')
{
    try {
        return \Morilog\Jalali\CalendarUtils::strftime($format, strtotime($timestamp));
    } catch (\Throwable $throwable) {
        return null;
    }
}

function toGorgian($timeStamp,$format='Y/m/d'){
    try {
        return \Morilog\Jalali\CalendarUtils::createDatetimeFromFormat($format, persianNumberToEnglish($timeStamp));
    } catch (\Throwable $throwable) {
        return null;
    }
}

function changeFile($path,$line,$text){
    $lines = file( $path , FILE_IGNORE_NEW_LINES );
    $lines[$line] = $text;
    file_put_contents( $path , implode( "\n", $lines ));
}

function clearString($string, $limit = 500){
    $string = filter_var(str_limit($string, $limit), FILTER_SANITIZE_STRING);
    $string = preg_replace('/&#?[a-z0-9]+;/i', ' ', $string);
    $string = trim(preg_replace('/\s\s+/', ' ', $string));
    return $string;
}

function slug($string){
    return str_replace(' ','-',$string);
}

function message($title='saved',$body='missionAccomplished',$type='success',$timer = true)
{
    if ($title == 'saved') {
        $title = 'ذخیره شد';
    }
    if ($body == 'missionAccomplished') {
        $body = 'عملیات با موفقیت انجام شد.';
    }

    session(['message.title'=>$title,'message.body'=>$body,'message.type'=>$type,'message.timer'=>$timer]);
}

function numberFormattoInt($value){
    return intval(str_replace(',', '', $value));
}

function setting($name, $type = 'default')
{
    try {
        $result = cache("settings_$type")->where('name', $name)->first();
    } catch (\Throwable $exception) {
        $result = \App\Models\Setting\setting::cache($type)->where('name', $name)->first();
    }

    try {
        if ($result->count()) {
            if ($result->type == 'file') {
                return $result;
            } elseif ($result->type == 'article' || $result->type == 'product' || $result->type == 'articleCategory' || $result->type == 'productCategory') {
                if (json_decode($result->value)) {
                    return json_decode($result->value);
                } else {
                    return [];
                }
            }
            return $result->value;
        }
    } catch (\Throwable $exception) {
        return '';
    }
}

function flatten($arr, $childName = "allchildren",$isParent=false, $depth = 0)
{
    $result = [];
    foreach ($arr as $key => $item) {
        $item['level'] = $depth;
        if (isset($item[$childName])) {
            if ($isParent) {
                $item[$childName] = [$item[$childName]];
            }
            $result = array_merge($result, flatten($item[$childName], $childName,$isParent, $depth + 1));
            unset($item[$childName]);
        }
        $result[] = $item;
    }
    return $result;
}

function offerCalc($price,$offer)
{
    return ($price - ($price * ($offer / 100)));
}

function uniqname($suffix = '')
{
    $uniq  =  uniqid(str_random(4)).str_replace('.','',microtime(true));
    $hash  =  bin2hex(openssl_random_pseudo_bytes(16));
    return mb_strtolower($hash.$uniq.$suffix);
}

function offPrice($price,$percent)
{
    return ($price - ($price * ($percent / 100)));
}

function persianNumberToEnglish($matches)
{
    $farsi_array = array("۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹");
    $english_array = array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
    return str_replace($farsi_array, $english_array, $matches);
}

function convertNumbers($matches)
{
    $farsi_array = array("۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹");
    $english_array = array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
    return str_replace($farsi_array, $english_array, $matches);
}

function numberToMonth($value)
{
    $number = ["01", "02", "03", "04", "05", "06", "07", "08", "09","10","11","12"];
    $month  = ['فروردین','اردیبهشت','خرداد','تیر','مرداد','شهریور','مهر','آبان','آذر','دی','بهمن','اسفند'];
    return str_replace($number, $month, $value);
}

function convertType($input)
{
    if ($input == 'true' || $input == 'false') {
        return (!!$input);
    }
    elseif ($input == 'null') {
        return null;
    }
    else {
        return $input;

    }
}

function kavenegar($message, $to,$isVerify = true,$type = 'sms')
{
    $apikey = env('kavenegar');
    $curl_handle = curl_init();
    if ($isVerify) {
        curl_setopt($curl_handle, CURLOPT_URL, "https://api.kavenegar.com/v1/$apikey/verify/lookup.json");
        curl_setopt($curl_handle, CURLOPT_POST, true);
        curl_setopt($curl_handle, CURLOPT_POSTFIELDS, [
            'template' => 'verify',
            'type' => $type,
            'receptor' => $to,
            'token' => $message,
        ]);
    } else {
        curl_setopt($curl_handle, CURLOPT_URL, "https://api.kavenegar.com/v1/$apikey/sms/send.json");
        curl_setopt($curl_handle, CURLOPT_POST, true);
        curl_setopt($curl_handle, CURLOPT_POSTFIELDS, [
            'receptor' => $to,
            'message' => $message,
        ]);
    }
    curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
    $query = curl_exec($curl_handle);
    curl_close($curl_handle);

    return response()->json(json_decode($query));
}

function referalCode($code)
{
    if ($code == null) {
        $code = 'emi_1';
    }
    $codeExplode = explode('_', $code);
    $organization_id = null;
    $user_id = null;
    $status = true;

    if (count($codeExplode) >= 2) {
        $organization_id = $codeExplode[1];
        if (\App\Models\Organization\organization::where('id', $organization_id)->count() == 0) {
            $status = false;
        }

        if (isset($codeExplode[2])) {
            $user_id = $codeExplode[2];
            if (\App\User::where('id', $user_id)->count() == 0) {
                $status = false;
            }
        }
    } else {
        $status = false;
    }

    return [
        'user_id' => $user_id,
        'organization_id' => $organization_id,
        'status' => $status
    ];
}

function storeFile($name, $path)
{
    $request = request();
    $file = null;
    if ($request->hasFile($name)) {
        $file = $request->file($name)->store('uploads/' . $path);
    }
    return $file;
}


function updateFile($name, $path,$oldFileFullPath)
{
    $request = request();
    $file = $oldFileFullPath;
    if ($request->hasFile($name)) {
        if ($oldFileFullPath) {
            \Illuminate\Support\Facades\Storage::delete($oldFileFullPath);
        }
        $file = $request->file($name)->store('uploads/' . $path);
    }
    return $file;
}

function curl_get_contents($url, $post_data = [], $header = null, $verbose = false, $ref_url = false, $cookie_location = false, $return_transfer = true)
{
    $pointer = curl_init();

    curl_setopt($pointer, CURLOPT_URL, $url);
    curl_setopt($pointer, CURLOPT_TIMEOUT, 40);
    curl_setopt($pointer, CURLOPT_RETURNTRANSFER, $return_transfer);
    curl_setopt($pointer, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US) AppleWebKit/534.10 (KHTML, like Gecko) Chrome/8.0.552.28 Safari/534.10");
    curl_setopt($pointer, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($pointer, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($pointer, CURLOPT_HEADER, false);
    curl_setopt($pointer, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($pointer, CURLOPT_AUTOREFERER, true);

    if ($header) {
        curl_setopt($pointer, CURLOPT_HTTPHEADER, $header);
    }

    if ($cookie_location !== false) {
        curl_setopt($pointer, CURLOPT_COOKIEJAR, $cookie_location);
        curl_setopt($pointer, CURLOPT_COOKIEFILE, $cookie_location);
        curl_setopt($pointer, CURLOPT_COOKIE, session_name() . '=' . session_id());
    }

    if ($verbose !== false) {
        $verbose_pointer = fopen($verbose, 'w');
        curl_setopt($pointer, CURLOPT_VERBOSE, true);
        curl_setopt($pointer, CURLOPT_STDERR, $verbose_pointer);
    }

    if ($ref_url !== false) {
        curl_setopt($pointer, CURLOPT_REFERER, $ref_url);
    }

    if (count($post_data) > 0) {
        curl_setopt($pointer, CURLOPT_POST, true);
        curl_setopt($pointer, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($pointer, CURLOPT_POSTFIELDS, $post_data);
    }

    $return_val = curl_exec($pointer);

    $http_code = curl_getinfo($pointer, CURLINFO_HTTP_CODE);

    if ($http_code == 404) {
        return false;
    }

    curl_close($pointer);

    unset($pointer);

    return $return_val;
}
